﻿/**
* @author b2ox
*/
package org.b2ox.pv3d.MikuMikuDance
{
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.tweens.*;

	/**
	 * 再生制御
	 */
	public class VMDControllerNop implements IVMDController
	{
		private var _tween:ITween;

		/**
		 * 指定時間なにもしない(VMDControllerSerialでの合成用など).
		 * 更新に関わるAPI部分は全て何もしない関数
		 * @param	duration
		 */
		public function VMDControllerNop(duration:Number):void
		{
			_tween = BetweenAS3.tween({dummy:0}, {dummy:0}, {dummy:0}, duration);
		}

		//-------------------------------------------------
		// 再生用のAPI

		public function get tween():ITween { return _tween; }
		public function get counterTween():ITween { return _tween; }
		public function get updaterTween():ITween { return _tween; }

		public function get looping():Boolean { return ! _tween.stopOnComplete; }
		public function set looping(loop:Boolean):void { _tween.stopOnComplete = ! loop; }

		public function play():void { _tween.play(); }
		public function stop():void { _tween.stop(); }
		public function togglePause():void { _tween.togglePause(); }
		public function gotoAndPlay(pos:Number):void { _tween.gotoAndPlay(pos); }
		public function gotoAndStop(pos:Number):void { _tween.gotoAndStop(pos); }

		public function get playing():Boolean { return _tween.isPlaying; }

		public function update():void {}

		public function resetParams():void {}
		public function applyPose():void {}
		public function applyCurrent():void {}
	}
}
