﻿package vocaloplus.controllers 
{
	import com.seacolorswind.dbi.AirDao;
	import flash.filesystem.File;
	import vocaloplus.threads.*;
	
	/**
	 * モジュール操作クラスです。
	 * @author Kazushi Tominaga (Seacolor)
	 * @see vocaloplus.models.SoundHolder
	 * @see vocaloplus.models.ModelHolder;
	 * @see vocaloplus.models.MotionHolder;
	 * @see vocaloplus.models.SceneHolder;
	 * @see mx.events.ModuleEvent.READY
	 */
	public class ModuleController 
	{
		/**
		 * モジュールの定義情報を格納したデータベースです。
		 */
		protected static const INFO_MODULE:AirDao = new AirDao(File.applicationDirectory.resolvePath("modules.db"));
		
		/**
		 * モーションモジュールをロードするスレッドオブジェクトを作成します。
		 * @param	id_or_name	該当モジュールのモジュールIDもしくは系統毎に一意なモジュール名です。
		 * @return	スレッドオブジェクトです。
		 */
		public static function makeMotionLoader(id_or_name:Object):LoadMotionThread {
			return new LoadMotionThread(INFO_MODULE, id_or_name);
		}
		/**
		 * モデルモジュールをロードするスレッドオブジェクトを作成します。
		 * @param	id_or_name	該当モジュールのモジュールIDもしくは系統毎に一意なモジュール名です。
		 * @return	スレッドオブジェクトです。
		 */
		public static function makeModelLoader(id_or_name:Object):LoadModelThread {
			return new LoadModelThread(INFO_MODULE, id_or_name);
		}
		/**
		 * 音声モジュールをロードするスレッドオブジェクトを作成します。
		 * @param	id_or_name	該当モジュールのモジュールIDもしくは系統毎に一意なモジュール名です。
		 * @return	スレッドオブジェクトです。
		 */
		public static function makeSoundLoader(id_or_name:Object):LoadSoundThread {
			return new LoadSoundThread(INFO_MODULE, id_or_name);
		}
	}
	
}