package org.wicketja.model;

import java.io.Serializable;
import java.util.Calendar;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;

import javax.persistence.Table;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 * TODO describe
 * @author daisuke
 * @author Tsutomu YANO
 */
@SuppressWarnings("serial")
@Entity
@Table(name = "NEWS_ENTRY", schema = "WICKETJA")
public class NewsEntry implements Serializable, Comparable<NewsEntry> {

    private Integer id;
    /** ニュースタイトル */
    private String title;
    /** 投稿日時 */
    private Calendar registerDate;
    /** 本文 */
    private String content;
    /** 無効化日 */
    private Calendar invalidate;

    @Id
    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Column(nullable = false)
    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Column(nullable = false)
    public Calendar getRegisterDate() {
        return registerDate;
    }

    public void setRegisterDate(Calendar calendar) {
        this.registerDate = calendar;
    }

    @Column(nullable = false, length = 1024)
    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Calendar getInvalidate() {
        return invalidate;
    }

    public void setInvalidate(Calendar invalidate) {
        this.invalidate = invalidate;
    }

    public int compareTo(NewsEntry another) {
        if (another == null) {
            return 1;
        }
        return this.getRegisterDate().compareTo(another.getRegisterDate());
    }

    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }
}
