#pragma once
namespace sf {
  enum struct Note 
  {
    C,CS,D,DS,E,F,FS,G,GS,A,AS,B
  };

  class TestSong
  {
  public:
    TestSong(SequenceTracksType& tracks);
    void AddNote(int channel,int step,float pitch,float velocity,int gatetime);
    void AddNote(int channel,int step,Note note,int octave,float velocity,int gatetime,float detune = 0.0f);
    void AddRest(int channel,int step);
    void CreateMappyData();
    void CreateTestTone();
    void CreateCosmicSurfin();
    float GetPitch(Note note ,int octave);
    ~TestSong();
  private:
    std::vector<int> stepCounters_;
    std::vector<float> noteTable_;
    SequenceTracksType& tracks_;
  };
}

