﻿#pragma once
/*
  ==============================================================================

   This file is part of the async
   Copyright 2005-10 by Satoshi Fujiwara.

   async can be redistributed and/or modified under the terms of the
   GNU General Public License, as published by the Free Software Foundation;
   either version 2 of the License, or (at your option) any later version.

   async is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with async; if not, visit www.gnu.org/licenses or write to the
   Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
   Boston, MA 02111-1307 USA

  ==============================================================================
*/
#include "singleton.h"
#include "exception.h"
#include "ring_buffer.h"
#include "wasapi.h"
#include "async_reader.h"
#include "sf_memory.h"
#include "toplevel_window.h"

namespace sf {
class application : public singleton<application>
{
public:
  struct exception
    : public sf::win32_error_exception 
  {
    exception(uint32_t hr) : win32_error_exception(hr) {};
    exception() : win32_error_exception() {} ;
  };

  application();
  ~application();
  
  int execute(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPTSTR    lpCmdLine,
                     int       nCmdShow);
  

  std::wstring& app_id(){return app_id_;};
  HINSTANCE instance_handle() {return instance_handle_;};
  enum player_status 
  {
    player_ready,
    player_prep_stop,
    player_stop,
    player_play,
    player_end,
    player_pause,
    player_prep_seek,
    player_seek,
    player_rew,
    player_ff,
    player_exit
  };

  void reader_thread_main();
  void output_thread_main();

  void change_status(uint32_t v,boost::memory_order o = boost::memory_order_seq_cst);
  uint32_t get_status(boost::memory_order o = boost::memory_order_seq_cst);
  
  void setup(const std::wstring& file_path);
  
  void play();
  void pause();
  void stop();

  uint64_t get_play_position() { return output_counter_;};
  void set_play_position(uint64_t pos);
  uint64_t get_data_size() { return reader_->total_data_bytes(); }
  void repeat_mode(bool v) { repeat_mode_ = v ;reader_->repeat_mode(v);}
  void exclusive_mode(bool v);
  bool exclusive_mode() const { return exclusive_mode_;}

private:
  void wasapi_setup();
  HINSTANCE instance_handle_;
  int return_code_;

  
  boost::thread reader_thread_;
  handle_holder event_reader_;
  std::wstring source_file_path_;
  std::unique_ptr<async_reader> reader_;
  sf::buffer_t read_buffer_;
  uint32_t read_index_;
  uint64_t read_position_;

  handle_holder event_output_;
  boost::thread output_thread_;
  std::unique_ptr<audio_base> wasapi_;
  uint64_t output_counter_;
  bool repeat_mode_;

  boost::atomic<uint32_t> status_;
  uint32_t status_backup_;
  sf::ringbuffer_t ringbuffer_;
  bool not_enqueue_;

  bool exclusive_mode_;

  sf::toplevel_window_ptr window_;
  static std::wstring app_id_;

};
}

