﻿/*
==============================================================================

This file is part of the async
Copyright 2005-10 by Satoshi Fujiwara.

async can be redistributed and/or modified under the terms of the
GNU General Public License, as published by the Free Software Foundation;
either version 2 of the License, or (at your option) any later version.

async is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with async; if not, visit www.gnu.org/licenses or write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
Boston, MA 02111-1307 USA

==============================================================================
*/
#include "StdAfx.h"
#include <commctrl.h>


#include "message_loop.h"
#include "sf_com.h"
#include "application.h"
#include "dout.h"

#if _DEBUG
#define _CRTDBG_MAP_ALLOC
#include <crtdbg.h>
#define new new(_NORMAL_BLOCK, __FILE__, __LINE__)
#endif

#ifndef HINST_THISCOMPONENT
EXTERN_C IMAGE_DOS_HEADER __ImageBase;
#define HINST_THISCOMPONENT ((HINSTANCE)&__ImageBase)
#endif


using namespace std;

namespace sf {
#ifdef _DEBUG
  std::wstring application::app_id_(L"SF.async_debug");
#else
  std::wstring application::app_id_(L"SF.async");
#endif

  application::application()
  {
    instance_handle_ = HINST_THISCOMPONENT;
    // ベースディレクトリの取得
    wchar_t dir[MAX_PATH];
    ::GetCurrentDirectoryW(MAX_PATH,dir);
    base_directory_.assign(dir);
  }

  application::~application()
  {
  };

  // アプリケーションを実行する
  int application::execute(HINSTANCE hInstance,
    HINSTANCE hPrevInstance,
    LPTSTR    lpCmdLine,
    int       nCmdShow)
  {
#ifdef _DEBUG
    ::_CrtSetDbgFlag(_CRTDBG_LEAK_CHECK_DF | _CRTDBG_ALLOC_MEM_DF);
#endif
    UNREFERENCED_PARAMETER(hPrevInstance);
    UNREFERENCED_PARAMETER(lpCmdLine);

    // wcoutで文字化けしないように、ロケールをデフォルト言語に設定する
    std::wcout.imbue(std::locale(""));

    // 2重起動の防止処理
    SECURITY_DESCRIPTOR sd;
    InitializeSecurityDescriptor(&sd,SECURITY_DESCRIPTOR_REVISION);
    SetSecurityDescriptorDacl(&sd, TRUE, 0, FALSE);	    
    SECURITY_ATTRIBUTES sec_attr;
    sec_attr.nLength = sizeof (sec_attr);
    sec_attr.lpSecurityDescriptor = &sd;
    sec_attr.bInheritHandle = TRUE; 
#ifdef _DEBUG 
    sf::handle_holder handle(::CreateMutex(&sec_attr, FALSE, _T("async_mutex_debug")));
#else
    sf::handle_holder handle(::CreateMutex(&sec_attr, FALSE, _T("async_mutex")));
#endif
    if(NULL == handle.get() || ::GetLastError() == ERROR_ALREADY_EXISTS)
    {
      return 0;
    }

    // プロセスの優先度を高に設定する
    SetPriorityClass(GetCurrentProcess(), HIGH_PRIORITY_CLASS);

    // コモンコントロールの初期化 
    static const INITCOMMONCONTROLSEX common_ctrls =
    {
      sizeof(INITCOMMONCONTROLSEX),
      ICC_STANDARD_CLASSES | ICC_BAR_CLASSES
    };
    InitCommonControlsEx(&common_ctrls);

    // Win RTの初期化
    RoInitialize(RO_INIT_MULTITHREADED);

    // COMをマルチスレッドで初期化
    sf::com_initialize init(0,multi_threaded);

    // プロセスの優先順位をPro Audioに変更する
    sf::av_mm_thread_characteristics avmm(wstring(L"Pro Audio"));
    avmm.set_priority(AVRT_PRIORITY_HIGH);

    // アプリケーションIDの登録
    sf::throw_if_err<application::exception>()(SetCurrentProcessExplicitAppUserModelID(app_id_.c_str()));

    // マルチメディアタイマの精度を1msに設定する
    timeBeginPeriod(1);

    // ダイアログウィンドウを作成する
    window_ = sf::create_toplevel_window(
      std::wstring(L"Media Player サンプル"),std::wstring(L"Media Player サンプル"));

    // メッセージ処理ループ
    WPARAM ret = sf::dialog_message_loop(reinterpret_cast<HWND>(window_->raw_handle()))();

    // マルチメディアタイマの粒度を元に戻す。
    timeEndPeriod(1);

    // プレイヤーのシャットダウン処理を行いリソースを解放する
    player_->process_event(sf::player::ev::Close());

    return ret;
  }

  // Playerを初期化する。
  void application::init_player(HWND vhwnd,HWND hwnd)
  {
    player_ = player::CreatePlayer(vhwnd,hwnd);
    player_init_ok_();
  }
  
}

