﻿/*
  dos.c

  functions for compatibility to doslib

  ( mainly contains file-oriented functions )

  Made by Studio Breeze. 1998, 2002


  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
 */

#include "sted.h"
#include "sted_screen.h"


/* variables */

//char fnc_func[10][32];
//char fnc_sfunc[10][32];
//char fnc_key[12][6];

/* ROLL UP, ROLL DOWN, INS, DEL,
   UP, LEFT, RIGHT, DOWN,
   CLR, HELP, HOME, UNDO */

/* console-oriented functions */

int
_dos_c_cls_al ( void )
{
  _iocs_b_clr_al();
  return 0;
}

int
_dos_c_cls_ed( void )
{
  _iocs_b_clr_ed();
  return 0;
}

int
_dos_c_curoff( void )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return 0;
  scr->SetCursor(EButtonOff);
  return 0;
}

int
_dos_c_curon( void )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return 0;
  scr->SetCursor(EButtonOn);
  return 0;
}

int
_dos_c_fnkmod( int in_mode )
{
  /* not implemented */
  return 0;
}

int
_dos_c_window( int in_x, int in_y )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return 0;
  scr->SetTextWindow(in_x, in_y);
  scr->Locate(0, 0);
  return 0;
}

int
_dos_fnckeygt( int in_fno, char *in_buff )
{
  /* not implemented */
  return 0;
}

int
_dos_fnckeyst( int fno, const char *buff )
{
  int i,j;
  const char *p;

  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return 0;

  p=buff;

  if (fno==0) {
    for ( i=0 ; i<10 ; i++ ) {
      for ( j=0 ; j<32 ; j++ ) {
	fnc_func[i][j]=*p++;
      }
    }
    for ( i=0 ; i<10 ; i++ ) {
      for ( j=0 ; j<32 ; j++ ) {
	fnc_sfunc[i][j]=*p++;
      }
    }
    for ( i=0 ; i<12 ; i++ ) {
      for ( j=0 ; j<6 ; j++ ) {
	fnc_key[i][j]=*p++;
      }
    }
  } else if ( fno<=10 ) {
    for ( j=0 ; j<32 ; j++ ) {
      fnc_func[fno-1][j]=*p++;
    }
  } else if ( fno<=20 ) {
    for ( j=0 ; j<32 ; j++ ) {
      fnc_sfunc[fno-11][j]=*p++;
    }
  } else if ( fno<=32 ) {
    for ( j=0 ; j<6 ; j++ ) {
      fnc_key[fno-21][j]=*p++;
    }
  }

  scr->SetFncKey(fnc_key);
  return 0;
}

int
_dos_inpout( int in_code )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return 0;

  if ( (in_code==0xfe) || (in_code==0xff) ) {
    return scr->KeyIn(in_code);
  }
}

/* functions */

void *
_dos_malloc(int in_size)
{
  void *tmp;

  tmp = (void *)malloc(in_size);
  if ( tmp == NULL ) tmp = (void *)0x82000000;

  return tmp;
  
}


/* file related */

dosmode_t
_dos_chmod( const char *in_name, dosmode_t in_atr )
{
  /* returns only one flag : is the file "name" directory? */

  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return 0;

  return scr->FileChmod(in_name, in_atr);
}

int
_dos_chdir( const char *in_name )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return 0;

  return scr->FileChdir(in_name);
}

int
_dos_curdir( int in_drive, char *out_buff )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return 0;

  return scr->FileCurdir(in_drive, out_buff);
}

int
_dos_curdrv( void )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return 0;

  return scr->FileCurdrv();
}

int
_dos_delete( const char *in_name )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return 0;

  return scr->FileDelete(in_name);
}

int _dos_drvctrl( int mode, int drive ) {

  return 2; /* media inserted, ready, not protected, enable eject by user,
	       no buffer, enable eject, not blink LED */
}

int
_dos_rename( const char *in_name, const char *in_nname )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return 0;

  return scr->FileRename(in_name, in_nname);
}

int _dos_super( int stack ) {

  return 1; /* ignore */
}

int
_dos_files (struct _x68_filbuf *in_buff, const char *in_name, int in_atr )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return 0;

  return scr->FileFiles(in_buff, in_name, in_atr);
}

int
_dos_nfiles( struct _x68_filbuf *in_buff )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return 0;

  return scr->FileNfiles(in_buff);
}

int _dos_setblock( void *memptr, int newsize ) {

  /* not implemented */
  return -1;  
}

int dskf( char drive_number ) {

  /* max 8 keta */
  return 58371500;
}

FILE
*fopen2( char *in_name, char *in_mode)
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return NULL;

  return scr->FileFopen(in_name, in_mode);
}
