#pragma once
/** @file
*  @brief MIDI Output̃wb_[t@C
*/
#include "boost/detail/lightweight_test.hpp"
#include "midi_input.h"
#include "midi_output.h"
#include "midi_message.h"
namespace sf {
class midi_test
{
public:
  midi_test()
  {
    // MIDI IN foCXăReiɊi[
    sf::midi::foCX̗();

    // MIDI OUT foCXăReiɊi[
    sf::midio::foCX̗();

    _.reset(new midi(sf::midi::foCXRei().begin()->id()));
    o_.reset(new midio(sf::midi::foCXRei().begin()->id()));
    
    _->MIDIbZ[W.connect(boost::bind(&midi_test::MIDIbZ[W,*this,_1,_2,_3));

  }

  ~midi_test()
  {
    ::midiDisconnect((HMIDI)_->nh(),o_->nh(),NULL);
  };

  void run_test()
  {


    // ReiɊi[foCX\
    std::for_each(sf::midi::foCXRei().begin(),sf::midi::foCXRei().end()
      ,[](const sf::midi::caps& c)
    {
      sf::wdout <<  L"MIDI Input Device: " << c.name() << std::endl;
    }
    );

    // MIDI Input̊ȒPȃeXg
    if(!sf::midi::foCXRei().empty())
    {
      try{
        _->MJn();
        _->M~();
        _->Zbg();
        _->N[Y();
      } catch (sf::midi̓G[& e)
      {
        sf::wdout << boost::wformat(L"Error: %s") % e.what() << std::endl;
      }
    }

  
    // ReiɊi[foCX\
    std::for_each(sf::midio::foCXRei().begin(),sf::midio::foCXRei().end()
      ,[](const sf::midio::foCX& c)
    {
      sf::wdout << L"MIDI Output Device: " << c.O() << std::endl;
    }
    );

    // MIDI Output̊ȒPȃeXg
    if(!sf::midio::foCXRei().empty())
    {
      try{
        o_->Zbg();
        o_->N[Y();
      } catch (sf::midio̓G[& e)
      {
        sf::wdout << boost::wformat(L"Error: %s") % e.what() << std::endl;
      }
    }

    o_->I[v();
    _->I[v();

    // 
    ::midiConnect((HMIDI)_->nh(),o_->nh(),NULL);
    _->MJn();
  }

  void MIDIbZ[W( boost::uint32_t bZ[W, boost::uint32_t MIDIbZ[W, boost::uint32_t ^CX^v)
  {

    switch( bZ[W )
    {
      // normal data message
    case MIM_DATA:
      {
        boost::uint32_t data2_ = ((MIDIbZ[W & 0xFF0000) >> 16);
        boost::uint32_t data1_ = ((MIDIbZ[W & 0xFF00) >> 8);
        boost::uint32_t status_ = ((MIDIbZ[W & 0xFF));

        SFTRACE((boost::wformat(_T("%2x %2x %2x \n")) % status_ % data1_ % data2_));
        switch (status_ & 0xf0)
        {
        case 0x90: // note on
          {
            SFTRACE((boost::wformat(_T("note on: %2x %2x \n")) % data1_ % data2_));
          }
          break;
        case 0x80: // note off
          {
          }
          break;
        case 0xa0: // poly after touch
          {
          }
          break;
        case 0xb0: // control change
          {
            SFTRACE((boost::wformat(_T("control change: %2x %2x \n")) % data1_ % data2_));
            //if(data1_ < 32 )
            //{
            //  m_control_change_buffer[status_ & 0xf][0] = data1_;
            //  m_control_change_buffer[status_ & 0xf][1] = data2_ << 7;

            //  input_messages::instance()->push_back
            //    (
            //    m_control_creators[data1_](current_step,cur_mac,(float)(data2_ << 7) / 16384.0f ,status_ & 0xf)
            //    );

            //} else {
            //  if(data1_ > 31 && data1_ < 64)
            //  {

            //    if(m_control_change_buffer[status_ & 0xf][0] == data1_)
            //    {
            //      data2_ += m_control_change_buffer[status_ & 0xf][1];
            //      input_messages::instance()->push_back(
            //        m_control_creators[data1_](current_step,(main_controller::instance()->current_machine()),(float)data2_ / 16384.0f,status_ & 0xf)
            //        );
            //    };
            //    m_control_change_buffer[status_ & 0xf][0] = 0;
            //    m_control_change_buffer[status_ & 0xf][1] = 0;
            //  } else {
            //    // 64 ... 119
            //    input_messages::instance()->push_back(
            //      m_control_creators[data1_](current_step,sf::model::main_controller::instance()->current_machine(),(float)(data2_) / 127.0f,status_ & 0xf)
            //      );
            //    m_control_change_buffer[status_ & 0xf][0] = 0;
            //    m_control_change_buffer[status_ & 0xf][1] = 0;
            //  }
            //}
          }
          break;
        case 0xc0: // program change
          {
          }
          break;
        case 0xd0: // channel after touch
          {
          }
          break;
        case 0xe0: // pitch bend
          {
            const boost::uint32_t value_ = data1_ << 7 | data2_;
            const float fvalue_ = value_ / 16384.0f; 
          }
          break;
        default:
          break;
        }
      }
      break;
    }
  }
private:
  boost::shared_ptr<midi> _;
  boost::shared_ptr<midio> o_;

};
}

