﻿#pragma once
/*
  ==============================================================================

   This file is part of the async
   Copyright 2005-10 by Satoshi Fujiwara.

   async can be redistributed and/or modified under the terms of the
   GNU General Public License, as published by the Free Software Foundation;
   either version 2 of the License, or (at your option) any later version.

   async is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with async; if not, visit www.gnu.org/licenses or write to the
   Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
   Boston, MA 02111-1307 USA

  ==============================================================================
*/
#include "singleton.h"
#include "exception.h"
#include "sf_memory.h"
#include "test_window.h"

namespace sf {
class application : public singleton<application>
{
public:
  struct exception
    : public sf::win32_error_exception 
  {
    exception(uint32_t hr) : win32_error_exception(hr) {};
    exception() : win32_error_exception() {} ;
  };

 
  application();
  ~application();
  
  int execute(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPTSTR    lpCmdLine,
                     int       nCmdShow);
  

  std::wstring& app_id(){return app_id_;};
  HINSTANCE instance_handle() {return instance_handle_;};
  
  // アプリケーションのカレントディレクトリを返す
  const std::wstring& base_directory() const { return base_directory_; }

 
// ----------------------------------------
private:
// ----------------------------------------

  //void wasapi_setup();
  HINSTANCE instance_handle_;
  int return_code_;
  
//---------------------------------------
// ファイル読取り関係
//---------------------------------------
public:

private:

  std::wstring base_directory_;
  std::unique_ptr<test_window> window_;

//--------------------------------
// シーケンサ
//--------------------------------
public:
private:
  static std::wstring app_id_;
  static const int WAIT_TIMEOUT_DEFAULT = 100; 
};
}

