#pragma once
#include <boost\shared_ptr.hpp>
#include "desctable.h"
#include "MemMan.h"
#include "Vector.h"

class Process;

class Thread{
public:
	Thread(Process *p, DWORD tid, DWORD eip);
	~Thread();

	void seteip(DWORD eip);
	const BYTE *gettss(){
		return (BYTE *)tss.get();
	}
	Process *GetProcess(){
		return p;
	}

	//̃XbhփXCb`
	void SwitchThread();
	
private:
	boost::shared_ptr<BYTE> dtbuf;
	boost::shared_ptr<TSS32> tss;
	boost::shared_ptr<TSS32> systss;
	GDT_IDT dt;
	Process *p;
	DWORD tid;
};

class ThreadMan
{
public:
	static void Init();
	static ThreadMan &Inst(){
		return *(ThreadMan *)buf;
	}


	Thread *CreateThread(Process *p, DWORD eip);

	void SwitchThread();
private:
	static BYTE buf[];
	static void* operator new(size_t size, void* pbuf){ return pbuf; }
	ThreadMan(void);
	~ThreadMan(void);

	Vector<Thread> thlist;
	DWORD curtid;

	DWORD curthread;
};

