﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace WindowsFormsApplication1
{
    public partial class Options : Form
    {
        public Options()
        {
            InitializeComponent();
        }

        private void Options_Load(object sender, EventArgs e)
        {
            txtInputDir.Text = appConfigData.DefaultInputPath;
            txtOutputDir.Text = appConfigData.DefaultOutputPath;
            if (appConfigData.OutputLogicType == com.dnetopen.MsOffice.MsWord2007.WordToJpeg.ConvertMethodType.Doc_Mdi_Tiff_Image)
            {
                rdoDocMdiTiffImg.Checked = true;
                rdoDocTiffImg.Checked = false;
            }
            else
            {
                rdoDocMdiTiffImg.Checked = false;
                rdoDocTiffImg.Checked = true;
            }

            if (appConfigData.MdiCompImg == com.dnetopen.MsOffice.MODIWSetting.RegstSettingValues.MdiCompImgValue.NONE_COMPRESS_IMAGE)
            {
                optMdiCompImg.Checked = false;
            }
            else
            {
                optMdiCompImg.Checked = true;
            }

            //cmbTiffDpi.SelectedValue = appConfigData.TiffDpi.ToString();
            cmbTiffDpi.SelectedValue = 300;

        }

        private void btnInputDir_Click(object sender, EventArgs e)
        {
            using (FolderBrowserDialog di = new FolderBrowserDialog())
            {
                di.Description = "取込初期フォルダを指定";
                di.SelectedPath = txtInputDir.Text;
                di.ShowNewFolderButton = true;

                if (di.ShowDialog() == DialogResult.OK)
                {
                    txtInputDir.Text = di.SelectedPath;
                }
            }
        }

        private void btnOutputDir_Click(object sender, EventArgs e)
        {
            using (FolderBrowserDialog di = new FolderBrowserDialog())
            {
                di.Description = "出力初期フォルダを指定";
                di.SelectedPath = txtOutputDir.Text;
                di.ShowNewFolderButton = true;

                if (di.ShowDialog() == DialogResult.OK)
                {
                    txtOutputDir.Text = di.SelectedPath;
                }
            }
        }

        private void button3_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            saveOption();
        }

        private void saveOption()
        {
            appConfigData.DefaultInputPath = txtInputDir.Text;
            appConfigData.DefaultOutputPath = txtOutputDir.Text;
            Properties.Settings.Default["取込標準フォルダ"] = appConfigData.DefaultInputPath;
            Properties.Settings.Default["出力標準フォルダ"] = appConfigData.DefaultOutputPath;
            if (rdoDocMdiTiffImg.Checked)
            {
                Properties.Settings.Default["変換方式"] = ((int)com.dnetopen.MsOffice.MsWord2007.WordToJpeg.ConvertMethodType.Doc_Mdi_Tiff_Image).ToString();
            }
            else
            {
                Properties.Settings.Default["変換方式"] = ((int)com.dnetopen.MsOffice.MsWord2007.WordToJpeg.ConvertMethodType.Doc_Tiff_Image).ToString();
            }

            if (optMdiCompImg.Checked)
            {
                Properties.Settings.Default["MDI出力時の画像圧縮"] = ((int)com.dnetopen.MsOffice.MODIWSetting.RegstSettingValues.MdiCompImgValue.COMPRESS_IMAGE).ToString();
            }
            else
            {
                Properties.Settings.Default["MDI出力時の画像圧縮"] = ((int)com.dnetopen.MsOffice.MODIWSetting.RegstSettingValues.MdiCompImgValue.NONE_COMPRESS_IMAGE).ToString();
            }

            Properties.Settings.Default.Save();
        }

        private void btnOk_Click(object sender, EventArgs e)
        {
            saveOption();
            this.Close();
        }

        private void Options_Shown(object sender, EventArgs e)
        {
            cmbTiffDpi.SelectedValue = cmbTiffDpi.Items[2];
            cmbTiffDpi.SelectedIndex= 2;

        }
    }
}
