﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Drawing;
using System.Drawing.Imaging;


namespace com.dnetopen.MsOffice.MsWord2007
{
    public class WordToJpeg
    {
        /// <summary>
        /// 出力画像形式
        /// </summary>
        public enum OutputImageType
        {
            /// <summary>
            /// ビットマップ (BMP) イメージ形式を取得します。
            /// </summary>
            Bmp,
            /// <summary>
            /// 拡張メタファイル (EMF) イメージ形式を取得します。
            /// </summary>
            Emf,
            /// <summary>
            /// Exif (Exchangeable Image File) 形式を取得します。
            /// </summary>
            Exif,
            /// <summary>
            /// GIF (Graphics Interchange Format) イメージ形式を取得します。
            /// </summary>
            Gif,
            /// <summary>
            /// Windows アイコン イメージ形式を取得します。
            /// </summary>
            Icon,
            /// <summary>
            /// JPEG (Joint Photographic Experts Group) イメージ形式を取得します。
            /// </summary>
            Jpeg,
            /// <summary>
            /// W3C PNG (Portable Network Graphics) イメージ形式を取得します。
            /// </summary>
            Png,
            /// <summary>
            /// TIFF (Tagged Image File Format) イメージ形式を取得します。
            /// </summary>
            Tiff,
            /// <summary>
            /// Windows メタファイル (WMF) イメージ形式を取得します。
            /// </summary>
            Wmf,
        }

        /// <summary>
        /// 出力方式
        /// </summary>
        public enum ConvertMethodType
        {
            Doc_Mdi_Tiff_Image = 0,
            Doc_Tiff_Image = 1
        }

        /// <summary>
        /// 出力する際の設定値格納クラス
        /// </summary>
        public class SettingValue
        {
            public string wordDocPath = string.Empty;
            public string tempFolderPath = string.Empty;
            public string outputFolderPath = string.Empty;

            /// <summary>
            /// Word Docを画像に変換するまでの工程
            /// </summary>
            public ConvertMethodType ConvMethodType = ConvertMethodType.Doc_Mdi_Tiff_Image;

            /// <summary>
            /// MDI出力する際の、Wordファイル内の画像圧縮を行うか
            /// </summary>
            public MODIWSetting.RegstSettingValues.MdiCompImgValue MdiCompImgType = com.dnetopen.MsOffice.MODIWSetting.RegstSettingValues.MdiCompImgValue.NONE_COMPRESS_IMAGE;

            /// <summary>
            /// 出力完了後にテンポラリ用のファイルを削除するかしないか。
            /// </summary>
            public bool IsDeleteTempFileOutputAfter = true;

            /// <summary>
            /// 出力する画像のフォーマット
            /// </summary>
            public OutputImageType OutputImgType = OutputImageType.Jpeg;
        }

        /// <summary>
        /// 出力結果値格納クラス
        /// </summary>
        public class ResultValue
        {
            /// <summary>
            /// 出力MDIファイルパス
            /// </summary>
            public string tempMdiPath = null;
            /// <summary>
            /// 出力Tiffファイルパス
            /// </summary>
            public string tempTiffPath = null;
            /// <summary>
            /// 変換画像ファイルパス
            /// </summary>
            public List<string> outputFilePath = new List<string>();
        }

    
        /// <summary>
        /// Wordファイルを変換する
        /// スレッドセーフではありません。
        /// </summary>
        /// <returns></returns>
        public ResultValue Excecute(SettingValue settings)
        {

            ResultValue result = new ResultValue();
           
            //設定をチェックする
            SettingCheck(settings);

            //Tempフォルダを確定する
            SetSettingDefValue(settings);

            //WordをTiffイメージに出力
            WortDocumentToTiffImage(settings, result);

            //MDIファイルをTiffに出力
            MdiFileToTiffImage(settings, result);
            
            //Mdi,Tiffイメージを画像に出力
            TiffToJpegs(settings, result);

            //一時ファイルを削除する
            DeleteTempFile(settings, result);

            return result;
        }

        /// <summary>
        /// 入力チェック
        /// 変換対象のDocと、出力先ディレクトリが正しく指定されているか。
        /// </summary>
        private void SettingCheck(SettingValue settings)
        {
            if (string.IsNullOrEmpty(settings.wordDocPath))
            {
                throw new ArgumentNullException("settings.wordDocPath", "対象のDocファイルパスが、指定されていません。");
            }
            else if (File.Exists(settings.wordDocPath) == false)
            {
                throw new ArgumentException("settings.wordDocPath", "対象のDocファイルが、存在しません。\nPath:" + settings.wordDocPath);
            }
            if (string.IsNullOrEmpty(settings.outputFolderPath))
            {
                throw new ArgumentNullException("settings.outputFolderPath", "出力先のフォルダが、指定されていません。");
            }
            else if (Directory.Exists(settings.outputFolderPath) == false)
            {
                Directory.CreateDirectory(settings.outputFolderPath);
                //throw new ArgumentException("settings.wordDocPath", "出力先のフォルダが、存在しません。\nPath:" + settings.outputFolderPath);
            }
        }

        /// <summary>
        /// Tempフォルダを確定する
        /// </summary>
        private void SetSettingDefValue(SettingValue settings)
        {
            string tmpPath = null;
            if (string.IsNullOrEmpty(settings.tempFolderPath))
            {
                tmpPath = System.IO.Path.GetTempPath();
                if (System.IO.Directory.Exists(tmpPath) == false)
                {
                    System.IO.Directory.CreateDirectory(tmpPath);
                }
                if (string.IsNullOrEmpty(settings.tempFolderPath))
                {
                    settings.tempFolderPath = tmpPath;
                }
            }

            if (settings.outputFolderPath.Substring(settings.outputFolderPath.Length - 2, 1) != "\\")
            {
                settings.outputFolderPath = settings.outputFolderPath + "\\";
            }

            if (settings.tempFolderPath.Substring(settings.tempFolderPath.Length - 2, 1) != "\\")
            {
                settings.tempFolderPath = settings.tempFolderPath + "\\";
            }


        }

        /// <summary>
        /// Word　Docを開いてMDIか、Tiffを出力する
        /// </summary>
        /// <param name="settings"></param>
        /// <param name="_result"></param>
        private void WortDocumentToTiffImage(SettingValue settings,ResultValue _result)
        {
            //http://support.microsoft.com/kb/302902/ja
            //Microsoft.Office.Interop.Word.Application app = null;
            //Microsoft.Office.Interop.Word.Document doc = null;
            object app = null;
            object doc = null;
            object doc2 = null;
            object[] Parameters;
            object varMissing = Type.Missing;
            object varFalseValue = false;
            object varTrueValue = true;
            MODIWSetting.RegstSettingValues beforeChangedValue = MODIWSetting.RegstSettingReader.ReadRegistry();
            MODIWSetting.RegstSettingValues newValue = new com.dnetopen.MsOffice.MODIWSetting.RegstSettingValues();
            newValue.MdiCompImg = settings.MdiCompImgType;
            newValue.DefaultFolder = beforeChangedValue.DefaultFolder;
            if (settings.ConvMethodType == ConvertMethodType.Doc_Mdi_Tiff_Image)
            {
                newValue.OutputFileType = com.dnetopen.MsOffice.MODIWSetting.RegstSettingValues.OutputFileTypes.MDI;
            }
            else
            {
                newValue.OutputFileType = com.dnetopen.MsOffice.MODIWSetting.RegstSettingValues.OutputFileTypes.TIFF;
            }
            
            newValue.PaperOrientation = beforeChangedValue.PaperOrientation;
            newValue.PaperSize = beforeChangedValue.PaperSize;
            newValue.PrintAfterAppStart = 0;
            newValue.TiffDpi = 300;
            MODIWSetting.RegstSettingWriter.WriteRegistry(newValue);

            try
            {
                try
                {
                    //WordApplicationオブジェクト生成
                    //app = new Microsoft.Office.Interop.Word.Application();
                    Type objClassType;
                    objClassType = Type.GetTypeFromProgID("Word.Application");
                    app = Activator.CreateInstance(objClassType);
                }
                catch (Exception ex)
                {
                    throw new ApplicationException("Wordアプリケーションの起動に失敗しました。" + "\n" + ex.Message, ex);
                }

                //↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓
                //Microsoft.Office.Interop.Word.WdAlertLevel arlertSetting = app.DisplayAlerts;
                //app.DisplayAlerts = Microsoft.Office.Interop.Word.WdAlertLevel.wdAlertsNone;
                //app.Visible = false;
                object arlertSetting = app.GetType().InvokeMember("DisplayAlerts",System.Reflection.BindingFlags.GetProperty, null, app, null);
                Parameters = new Object[1];
                Parameters[0] = 0;
                app.GetType().InvokeMember("DisplayAlerts", System.Reflection.BindingFlags.SetProperty, null, app, Parameters);
                Parameters = new Object[1];
                Parameters[0] = false;
                app.GetType().InvokeMember("Visible", System.Reflection.BindingFlags.SetProperty, null, app, Parameters);
                //↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑

                try
                {
                    //Open対象Wordパス
                    object docPath = settings.wordDocPath;
                    #region WordDocを開く

                    try
                    {
                        Object confirmConversions = Type.Missing;
                        Object readOnly = Type.Missing;
                        Object addToRecentFiles = Type.Missing;
                        Object passwordDocument = Type.Missing;
                        Object passwordTemplate = Type.Missing;
                        Object revert = Type.Missing;
                        Object writePasswordDocument = Type.Missing;
                        Object writePasswordTemplate = Type.Missing;
                        Object format = Type.Missing;
                        Object encoding = Type.Missing;
                        Object visible = Type.Missing;
                        Object openConflictDocument = Type.Missing;
                        Object openAndRepair = Type.Missing;
                        Object documentDirection = Type.Missing;
                        Object noEncodingDialog = Type.Missing;
                        //↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓
                        //doc = doc.Open(ref docPath, ref confirmConversions,
                        //                       ref readOnly,
                        //                       ref addToRecentFiles,
                        //                       ref passwordDocument,
                        //                       ref passwordTemplate,
                        //                       ref revert,
                        //                       ref writePasswordDocument,
                        //                       ref writePasswordTemplate,
                        //                       ref format,
                        //                       ref encoding,
                        //                       ref visible,
                        //                       ref openConflictDocument,
                        //                       ref openAndRepair,
                        //                       ref documentDirection,
                        //                       ref noEncodingDialog);
                        doc2 = app.GetType().InvokeMember("Documents", System.Reflection.BindingFlags.GetProperty, null, app, null);
                        Parameters = new Object[16];
                        Parameters[0] = docPath;
                        Parameters[1] = Type.Missing;
                        Parameters[2] = Type.Missing;
                        Parameters[3] = Type.Missing;
                        Parameters[4] = Type.Missing;
                        Parameters[5] = Type.Missing;
                        Parameters[6] = Type.Missing;
                        Parameters[7] = Type.Missing;
                        Parameters[8] = Type.Missing;
                        Parameters[9] = Type.Missing;
                        Parameters[10] = Type.Missing;
                        Parameters[11] = Type.Missing;
                        Parameters[12] = Type.Missing;
                        Parameters[13] = Type.Missing;
                        Parameters[14] = Type.Missing;
                        Parameters[15] = Type.Missing;
                        doc = doc2.GetType().InvokeMember("Open", System.Reflection.BindingFlags.InvokeMethod, null, doc2, Parameters);
                        //↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑
                       
                    }
                    catch (Exception ex)
                    {
                        throw new ApplicationException("WordファイルのOpenに失敗しました。\nPath:" + settings.wordDocPath + "\n" + ex.Message, ex);
                    }

                    #endregion

                    #region Docから、Microsoft Office Document Image Writer　へ、MDIファイルとして印刷ファイル出力

                    try
                    {
                        object FileName = "";
                        //↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓
                        //object Range = WdPrintOutRange.wdPrintAllDocument;
                        object Range = 0;
                        //↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑
                        //↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓
                        //object Item = WdPrintOutItem.wdPrintDocumentContent;
                        object Item = 0;
                        //↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑
                        object Copies = 1;
                        object Pages = "";
                        //↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓
                        //object PageType = WdPrintOutPages.wdPrintAllPages;
                        object PageType = 0;
                        //↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑
                        object ManualDuplexPrint = false;
                        object Collate = true;
                        object Background = true;
                        object PrintToFile = true;
                        object PrintZoomColumn = 0;
                        object PrintZoomRow = 0;
                        object PrintZoomPaperWidth = 0;
                        object PrintZoomPaperHeight = 0;
                        
                        //http://msdn.microsoft.com/ja-jp/library/microsoft.office.tools.word.document.printout(VS.80).aspx
                        //http://social.msdn.microsoft.com/forums/zh-TW/805/thread/0c5b9e70-b28b-4c9f-9f00-57fefcd02215/
                        object outputFilePath;
                        if (settings.ConvMethodType == ConvertMethodType.Doc_Mdi_Tiff_Image)
                        {
                            outputFilePath = settings.tempFolderPath + System.Guid.NewGuid().ToString() + ".mdi";                        
                        }
                        else
                        {
                            outputFilePath = settings.tempFolderPath + System.Guid.NewGuid().ToString() + ".tiff";
                        }
                        //↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓
                        //string beforeChangedPrintName = app.ActivePrinter;
                        object beforeChangedPrintName = app.GetType().InvokeMember("ActivePrinter", System.Reflection.BindingFlags.GetProperty, null, app, null);
                        //↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑

                        string printName = Printer.MODIWPrinter.GetMODIWName();
                        if (string.IsNullOrEmpty(printName))
                        {
                            throw new ApplicationException("Microsoft Office Document Image Writer　が、見つかりません。");
                        }

                        //↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓
                        //app.ActivePrinter = printName;
                        Parameters = new Object[1];
                        Parameters[0] = printName;
                        app.GetType().InvokeMember("ActivePrinter", System.Reflection.BindingFlags.SetProperty, null, app, Parameters);
                        //↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑

                        //↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓
                        //doc.PrintOut(ref varFalseValue
                        //            , ref varFalseValue
                        //            , ref varMissing
                        //            , ref outputFilePath
                        //            , ref varMissing
                        //            , ref varMissing
                        //            , ref varMissing
                        //            , ref varMissing
                        //            , ref varMissing
                        //            , ref varMissing
                        //            , ref PrintToFile
                        //            , ref varMissing
                        //            , ref varMissing
                        //            , ref varMissing
                        //            , ref varMissing
                        //            , ref varMissing
                        //            , ref varMissing
                        //            , ref varMissing);
                        Parameters = new Object[18];
                        Parameters[0] = varFalseValue;
                        Parameters[1] = varFalseValue;
                        Parameters[2] = varMissing;
                        Parameters[3] = outputFilePath;
                        Parameters[4] = varMissing;
                        Parameters[5] = varMissing;
                        Parameters[6] = varMissing;
                        Parameters[7] = varMissing;
                        Parameters[8] = varMissing;
                        Parameters[9] = varMissing;
                        Parameters[10] = PrintToFile;
                        Parameters[11] = varMissing;
                        Parameters[12] = varMissing;
                        Parameters[13] = varMissing;
                        Parameters[14] = varMissing;
                        Parameters[15] = varMissing;
                        Parameters[16] = varMissing;
                        Parameters[17] = varMissing;
                        doc.GetType().InvokeMember("PrintOut", System.Reflection.BindingFlags.InvokeMethod, null, doc, Parameters);
                        //↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑

                        //↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓
                        //app.ActivePrinter = beforeChangedPrintName;
                        Parameters = new Object[1];
                        Parameters[0] = beforeChangedPrintName;
                        app.GetType().InvokeMember("ActivePrinter", System.Reflection.BindingFlags.SetProperty, null, app, Parameters);
                        //↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑
                        
                        _result.tempMdiPath = outputFilePath.ToString();
                    }
                    catch (Exception ex)
                    {
                        throw new ApplicationException("Wordファイルのtif出力に失敗しました。" + "\n" + ex.Message, ex);
                    }

                    #endregion
                }
                finally
                {
                    if (doc != null)
                    {
                        //↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓
                        //doc.Close(ref varMissing, ref varMissing, ref varMissing);
                        Parameters = new Object[3];
                        Parameters[0] = varMissing;
                        Parameters[1] = varMissing;
                        Parameters[2] = varMissing;
                        doc.GetType().InvokeMember("Close", System.Reflection.BindingFlags.InvokeMethod, null, doc, Parameters);
                        //↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑
                    }
                }
                //↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓
                //app.DisplayAlerts = arlertSetting;
                Parameters = new Object[1];
                Parameters[0] = arlertSetting;
                app.GetType().InvokeMember("DisplayAlerts", System.Reflection.BindingFlags.SetProperty, null, app, Parameters);
                //↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑
            }
            finally
            {
                if (app != null)
                {
                    //↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓
                    //app.Quit(ref varMissing, ref varMissing, ref varMissing);
                    Parameters = new Object[3];
                    Parameters[0] = varMissing;
                    Parameters[1] = varMissing;
                    Parameters[2] = varMissing;
                    app.GetType().InvokeMember("Quit", System.Reflection.BindingFlags.InvokeMethod, null, app, Parameters);
                    //↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑
                }
                ReleaseComObj(doc2);
                ReleaseComObj(doc);
                ReleaseComObj(app);
            }

            MODIWSetting.RegstSettingWriter.WriteRegistry(beforeChangedValue);
        }

        /// <summary>
        /// MDIからTiffファイルをMODIを使って出力する
        /// </summary>
        /// <param name="settings"></param>
        /// <param name="_result"></param>
        private void MdiFileToTiffImage(SettingValue settings, ResultValue _result)
        {
            if (settings.ConvMethodType != ConvertMethodType.Doc_Mdi_Tiff_Image)
            {
                _result.tempTiffPath = _result.tempMdiPath;
                return;
            }
            object[] Parameters;
            //↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓
            //MODI.Document doc = new MODI.Document();
            Type objClassType;
            object objModi = null;
            objClassType = Type.GetTypeFromProgID("MODI.Document");
            objModi = Activator.CreateInstance(objClassType);
            //↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑
            
            try
            {
                //↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓  //objModi.Create(_result.tempMdiPath);
                Parameters = new Object[1];
                Parameters[0] = _result.tempMdiPath;
                objModi.GetType().InvokeMember("Create", System.Reflection.BindingFlags.InvokeMethod, null, objModi, Parameters);
                //↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑

                _result.tempTiffPath = settings.tempFolderPath + System.Guid.NewGuid() + ".tif";

                //↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓  //objModi.Create(_result.tempMdiPath);
                //objModi.SaveAs(_result.tempTiffPath, MODI.MiFILE_FORMAT.miFILE_FORMAT_TIFF, MODI.MiCOMP_LEVEL.miCOMP_LEVEL_HIGH);
                Parameters = new Object[3];
                Parameters[0] = _result.tempTiffPath;
                Parameters[1] = 1;
                Parameters[2] = 2;
                objModi.GetType().InvokeMember("SaveAs", System.Reflection.BindingFlags.InvokeMethod, null, objModi, Parameters);
                //↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑

            }
            finally
            {
                if (objModi != null)
                {
                    //↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓  //objModi.Create(_result.tempMdiPath);
                    //objModi.Close(false);
                    Parameters = new Object[1];
                    Parameters[0] = false;
                    objModi.GetType().InvokeMember("Close", System.Reflection.BindingFlags.InvokeMethod, null, objModi, Parameters);
                    //↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑                
                    ReleaseComObj(objModi);
                }
            }
            
        }

        /// <summary>
        /// Tiffファイルを任意の画像形式に変換する
        /// </summary>
        /// <param name="settings"></param>
        /// <param name="_result"></param>
        private void TiffToJpegs(SettingValue settings, ResultValue _result)
        {
            using (Bitmap a = new Bitmap(_result.tempTiffPath, true))
            {
                string imgKey = Path.GetFileNameWithoutExtension(settings.wordDocPath) + "@@@@@@@@@@" + System.Guid.NewGuid().ToString().Substring(0, 8);
                a.SetResolution(600, 600);
                System.Drawing.Imaging.FrameDimension oFDimension;
                oFDimension = new System.Drawing.Imaging.FrameDimension(a.FrameDimensionsList[0]);
                for (int i = 0; i < a.GetFrameCount(oFDimension); i++)
                {
                    
                    a.SelectActiveFrame(oFDimension, i);

                    string fileExtension = "";
                    ImageFormat imgFormat;
                    switch (settings.OutputImgType)
                    {
                        case OutputImageType.Bmp:
                            fileExtension = ".bmp";
                            imgFormat = ImageFormat.Bmp;
                            break;
                        case OutputImageType.Emf:
                            fileExtension = ".emf";
                            imgFormat = ImageFormat.Emf;
                            break;
                        case OutputImageType.Exif:
                            fileExtension = ".exif";
                            imgFormat = ImageFormat.Exif;
                            break;
                        case OutputImageType.Gif:
                            fileExtension = ".gif";
                            imgFormat = ImageFormat.Gif;
                            break;
                        case OutputImageType.Icon:
                            fileExtension = ".ico";
                            imgFormat = ImageFormat.Icon;
                            break;
                        case OutputImageType.Jpeg:
                            fileExtension = ".jpg";
                            imgFormat = ImageFormat.Jpeg;
                            break;
                        case OutputImageType.Png:
                            fileExtension = ".png";
                            imgFormat = ImageFormat.Png;
                            break;
                        case OutputImageType.Tiff:
                            fileExtension = ".tif";
                            imgFormat = ImageFormat.Tiff;
                            break;
                        case OutputImageType.Wmf:
                            fileExtension = ".wmf";
                            imgFormat = ImageFormat.Wmf;
                            break;
                        default:
                            fileExtension = ".jpg";
                            imgFormat = ImageFormat.Jpeg;
                            break;
                    }


                    string jpgPath = settings.outputFolderPath + imgKey.Replace("@@@@@@@@@@",i.ToString()) + fileExtension;
                    a.Save(jpgPath, imgFormat);
                    _result.outputFilePath.Add(jpgPath);
                }
            }
        }

        /// <summary>
        /// 一時ファイルを削除する
        /// </summary>
        /// <param name="settings"></param>
        /// <param name="_result"></param>
        private void DeleteTempFile(SettingValue settings, ResultValue _result)
        {
            if (settings.IsDeleteTempFileOutputAfter)
            {
                if (string.IsNullOrEmpty(_result.tempMdiPath) == false && File.Exists(_result.tempMdiPath))
                {
                    File.Delete(_result.tempMdiPath);
                }
                if (string.IsNullOrEmpty(_result.tempTiffPath) == false && File.Exists(_result.tempTiffPath))
                {
                    File.Delete(_result.tempTiffPath);
                }
            }
        }

        /// <summary>
        /// Word Com参照を開放する
        /// </summary>
        /// <param name="obj"></param>
        internal static void ReleaseComObj(object obj)
        {
            try
            {
                if (obj == null) return;

                int i = 0;
                do
                {
                    //オブジェクトを解放する操作
                    i = System.Runtime.InteropServices.Marshal.ReleaseComObject(obj);
                } while (i > 0);
            }
            catch
            {
                //例外は発生させない
            }
        }

    }
}
