﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace com.dnetopen.MsOffice.Check
{
    public class LocalInstall
    {
        /// <summary>
        /// ワードがInstallされているか
        /// </summary>
        /// <returns></returns>
        public static bool IsInstallWord()
        {
            object app = null;
            try
            {
                Type objClassType;
                objClassType = Type.GetTypeFromProgID("Word.Application");
                app = Activator.CreateInstance(objClassType);
                if (app == null)
                {
                    return false;
                }
            }
            catch
            {
                return false;
            }
            finally
            {
                if (app != null)
                {
                    try
                    {
                        object[] Parameters;
                        object varMissing = Type.Missing;
                        //↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓
                        //app.Quit(ref varMissing, ref varMissing, ref varMissing);
                        Parameters = new Object[3];
                        Parameters[0] = varMissing;
                        Parameters[1] = varMissing;
                        Parameters[2] = varMissing;
                        app.GetType().InvokeMember("Quit", System.Reflection.BindingFlags.InvokeMethod, null, app, Parameters);
                        //↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑
                    }
                    catch
                    {
                    }
                    com.dnetopen.MsOffice.MsWord2007.WordToJpeg.ReleaseComObj(app);
                }
            }
            return true;
        }

        /// <summary>
        /// ワードのバージョンを取得
        /// </summary>
        /// <returns></returns>
        public static string GetInstallWordVersion()
        {
            object app = null;
            object ver = null;
            try
            {
                Type objClassType;
                objClassType = Type.GetTypeFromProgID("Word.Application");
                app = Activator.CreateInstance(objClassType);
                if (app == null)
                {
                    throw new ApplicationException("Wordがインストールされていません。");
                }
                ver = app.GetType().InvokeMember("Version", System.Reflection.BindingFlags.GetProperty, null, app, null);
            }
            catch
            {
                throw new ApplicationException("Wordがインストールされていません。");
            }
            finally
            {
                if (app != null)
                {
                    try
                    {
                        object[] Parameters;
                        object varMissing = Type.Missing;
                        //↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓
                        //app.Quit(ref varMissing, ref varMissing, ref varMissing);
                        Parameters = new Object[3];
                        Parameters[0] = varMissing;
                        Parameters[1] = varMissing;
                        Parameters[2] = varMissing;
                        app.GetType().InvokeMember("Quit", System.Reflection.BindingFlags.InvokeMethod, null, app, Parameters);
                        //↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑
                    }
                    catch
                    {
                    }
                    com.dnetopen.MsOffice.MsWord2007.WordToJpeg.ReleaseComObj(app);
                }
            }
            return ver.ToString();

        }

        /// <summary>
        /// MicrosoftOfficeDocumentImageがInstallされているか
        /// </summary>
        /// <returns></returns>
        public static bool IsInstallMODI()
        {
            
            object objModi = null;
            try
            {
                Type objClassType;
                
                objClassType = Type.GetTypeFromProgID("MODI.Document");
                objModi = Activator.CreateInstance(objClassType);
                if (objModi == null)
                {
                    return false;
                }
            }
            catch
            {
                return false;
            }
            finally
            {
                if (objModi != null)
                {
                    try
                    {
                        object[] Parameters;
                        object varMissing = Type.Missing;
                        //↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓  //objModi.Create(_result.tempMdiPath);
                        //objModi.Close(false);
                        Parameters = new Object[1];
                        Parameters[0] = false;
                        objModi.GetType().InvokeMember("Close", System.Reflection.BindingFlags.InvokeMethod, null, objModi, Parameters);
                        //↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑                
                        com.dnetopen.MsOffice.MsWord2007.WordToJpeg.ReleaseComObj(objModi);
                    }
                    catch
                    {
                    }
                    com.dnetopen.MsOffice.MsWord2007.WordToJpeg.ReleaseComObj(objModi);
                }
            }
            return true;
        }

        /// <summary>
        /// MODIのプロパティ設定Registryが登録されているか
        /// </summary>
        /// <returns></returns>
        public static bool IsRegstMODIRegistry()
        {
            string ret = com.dnetopen.MsOffice.MODIWSetting.RegstChecker.GetLatestRegistryKey();
            if (ret == null)
            {
                return false;
            }
            else
            {
                return true;
            }

        }
    }
}
