#ifndef _XERCESC_UTILS_XMLCH_PTR_HPP_
#define _XERCESC_UTILS_XMLCH_PTR_HPP_

#include <xercesc/util/XMLString.hpp>

namespace xercesc_utils {

/**
 * XMLCh*̕Ǘ邽߂̃bp[łB
 * ̐Lł܂B
 *
 * @author Yutaka ITO
 */
class XMLChPtr {
private:
  XMLCh* buffer_;

public:
  XMLChPtr() : buffer_(new XMLCh[1]) {
    buffer_[0]=0;
  }

  explicit XMLChPtr(const XMLCh* const buffer) {
    copy(buffer);
  }

  ~XMLChPtr() {
    delete [] buffer_;
  }

  XMLChPtr(const XMLChPtr& ptr) {
    copy(ptr.buffer_);
  }

  XMLChPtr& operator=(const XMLChPtr& ptr) {
    copy(ptr.buffer_);
  }

public:
  /**
   * XMLCh*ւ̃LXgZqłB
   */
  operator const XMLCh* const () const {
    return buffer_;
  }

private:
  void copy(const XMLCh* const buffer) {
    buffer_ = new XMLCh[xercesc::XMLString::stringLen(buffer) + 1];
    xercesc::XMLString::copyString(buffer_, buffer);
  }

public:
  /**
   * [̋󔒕폜܂B
   */
  const XMLCh* const trim() {
    xercesc::XMLString::trim(buffer_);
    return buffer_;
  }

public:
  XMLChPtr& operator+=(const XMLCh* const ptr) {
    const unsigned int size = xercesc::XMLString::stringLen(buffer_) + xercesc::XMLString::stringLen(ptr);
    XMLCh* newBuffer = new XMLCh[size + 1];
    xercesc::XMLString::copyString(newBuffer, buffer_);
    xercesc::XMLString::catString(newBuffer, ptr);
    delete[] buffer_;
    buffer_ = newBuffer;

    return *this;
  }
};

}  // namespace xercesc_utils

#endif
