#include "SampleHandler.hpp"

#include <iostream>
using namespace std;

#include <xercesc/util/PlatformUtils.hpp>
#include <xercesc/util/TransService.hpp>
#include <xercesc/util/XMLString.hpp>
using namespace xercesc;

#include <xercesc_utils/XMLCh2Char.hpp>
using namespace xercesc_utils;

/**
 * ^O̊JnoĂяo郁\bhłB
 */
void SampleHandler::startElement(const XMLCh* const uri, const XMLCh* const localname,
                                 const XMLCh* const qname, const Attributes& attrs) {
  cout << "start  : " << XMLCh2Char(localname) << endl;
}

/**
 * ^ȌIoĂяo郁\bhłB
 */
void SampleHandler::endElement(const XMLCh* const uri, const XMLCh* const localname,
                               const XMLCh* const qname) {
  cout << "end    : " << XMLCh2Char(localname) << endl;
}

/**
 * ^O̕oĂяo郁\bhłB
 */
void SampleHandler::characters(const XMLCh* const chars, const unsigned int length) {
  XMLCh* buffer=new XMLCh[XMLString::stringLen(chars)+1];
  XMLString::copyString(buffer, chars);
  XMLString::trim(buffer);

  cout << "content: " << XMLCh2Char(buffer) << endl;
  delete[] buffer;
}
