package jp.gr.java_conf.ykhr.eclipse.plugin.autocp;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;


public class DisableAction extends AutoCpAction {
    
    @Override
    protected void doRun(IProject project) throws CoreException {
        if (project.hasNature(Activator.NATURE_ID)) {
            IProjectDescription description = project.getDescription();
            String[] natureIds = description.getNatureIds();
            String[] newIds = new String[natureIds.length - 1];
            
            int index = 0;
            for (String id : natureIds) {
                if (!id.equals(Activator.NATURE_ID)) {
                    newIds[index++] = id;
                }
            }
            description.setNatureIds(newIds);
            project.setDescription(description, null);
        }
    }

}
