package jp.gr.java_conf.ykhr.common.converter;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

import jp.gr.java_conf.ykhr.common.ex.ReadException;
import jp.gr.java_conf.ykhr.common.utils.ReaderUtils;
import jp.gr.java_conf.ykhr.common.utils.Utils;
import jp.gr.java_conf.ykhr.csvutil.core.CSVElement;

/**
 * priority𗘗pBeanɕϊConverter
 * 
 * @author y-ohira
 */
public class PriorityConverter implements Converter {
    
    private boolean existHeader;
    
    public PriorityConverter() {
        this(false);
    }
    
    public PriorityConverter(boolean existHeader) {
        this.existHeader = existHeader;
    }

    /* (non-Javadoc)
     * @see jp.gr.java_conf.ykhr.common.converter.Converter#toBeanCollection(java.lang.Class, java.util.Collection)
     */
    public <T>Collection<T> toBeanCollection(Class<T> clazz, Collection<String[]> elements)
            throws ReadException {
        
        Map<CSVElement, PropertyDescriptor> priorityToProperty 
            = getPriorityToPropertyMapping(clazz);
        Collection<T> beans = new ArrayList<T>();
        
        Iterator<String[]> iter = elements.iterator();
        if (existHeader && iter.hasNext()) {
            // skip header
            iter.next();
        }
        if (!iter.hasNext()) {
            return beans;
        }
        
        
        for ( ; iter.hasNext(); ) {
            String[] data = iter.next();
            T bean = ReaderUtils.createBeanInstance(clazz);
            
            int i = 0;
            for (PropertyDescriptor desc : priorityToProperty.values()) {
                Method method = desc.getWriteMethod();
                Class<?>[] types = method.getParameterTypes();
                if (types.length < 1) {
                    continue;
                }

                Object param = ReaderUtils.convertType(data[i++], types[0]);
                if (param != null) {
                    ReaderUtils.setObject(bean, method, param);
                }
            }
            
            beans.add(bean);
        }
        
        return beans;
    }

    /**
     * vCIeB̃vpeBւ̃}bsO擾B
     * 
     * @param <T>
     * @param clazz
     * @return
     * @throws ReadException
     */
    private <T> Map<CSVElement, PropertyDescriptor> getPriorityToPropertyMapping(Class<T> clazz) 
    throws ReadException {
        Map<CSVElement, PropertyDescriptor> priorityToProperty 
            = new TreeMap<CSVElement, PropertyDescriptor>(Utils.PRIORITY_COMP);;
        try {
            priorityToProperty.putAll(Utils.createCsvToPropertyInfo(clazz));
        } catch (IntrospectionException e) {
            throw new ReadException(e);
        }
        return priorityToProperty;
    }

}
