package jp.gr.java_conf.ykhr.excelutil;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import jp.gr.java_conf.ykhr.common.converter.Converter;
import jp.gr.java_conf.ykhr.common.converter.HeaderBaseConverter;
import jp.gr.java_conf.ykhr.common.ex.ReadException;
import jp.gr.java_conf.ykhr.common.utils.Utils;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;

public class ExcelReader {
    
    private static final Converter DEFAULT_CONVERTER = new HeaderBaseConverter();

    private Converter converter;
    
    public ExcelReader() {
        this(DEFAULT_CONVERTER);
    }
    
    public ExcelReader(Converter converter) {
        this.converter = converter;
    }
    
    public <T>Collection<T> read(File file, Class<T> clazz) throws ReadException {
        InputStream is = null;
        try {
            is = new FileInputStream(file);
            return read(is, clazz);
        } catch (IOException e) {
            throw new ReadException(e);
        } finally {
            Utils.close(is);
        }
    }
    
    public <T>Collection<T> read(InputStream is, Class<T> clazz) throws ReadException {

        Collection<String[]> elements = readExcel(is);
        Collection<T> result = convert(elements, clazz);
        return result;
    }

    private <T>Collection<T> convert(Collection<String[]> elements, Class<T> clazz)
    throws ReadException {
        
        Collection<T> result = converter.toBeanCollection(clazz, elements);
        return result;
    }

    private Collection<String[]> readExcel(InputStream is) throws ReadException {
        Workbook book = null;
        
        try {
            book = Workbook.getWorkbook(is);
            Sheet[] sheets = book.getSheets();
            if (sheets.length == 0) {
                throw new ReadException();
            }
            
            Sheet sheet = sheets[0];
            
            List<String[]> result = new ArrayList<String[]>();
            int columns = sheet.getColumns();
            int rows = sheet.getRows();
            
            for (int i = 0; i < rows; i++) {
                String[] data = new String[columns];
                for (int j = 0; j < columns; j++) {
                    data[j] = sheet.getCell(j, i).getContents();
                }
                result.add(data);
            }
            
            return result;
            
        } catch (IOException e) {
            throw new ReadException(e);
        } catch(BiffException e) {
            throw new ReadException(e);
        } finally {
            if (book != null) {
                book.close();
            }
        }
    }

}
