package jp.gr.java_conf.ykhr.eclipse.plugin.chocoxslt;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;

public class RunXsltWithLastConfigAction extends XsltAction {
    
    /**
     * @see IActionDelegate#run(IAction)
     */
    public void run(IAction action) {
        IFile xslFile = (IFile) ((IStructuredSelection) selection).getFirstElement();
        InputCache cache = new InputCache(xslFile);
        
        if (!cache.hasLastConfig()) {
            MessageDialog.openError(Activator.getShell(), "Error", Messages.Message_NoConfig); //$NON-NLS-1$
            return;
        }

        IProject project = xslFile.getProject();
        RunDescription desc = new RunDescription();
        desc.setXsl(xslFile.getLocation().toOSString());
        desc.setInput(toSystemPath(project, cache.getStoreValue(InputCache.KEY_INPUT)));
        desc.setOutput(toSystemPath(project, cache.getStoreValue(InputCache.KEY_OUTPUT)));
        desc.setProperty(toSystemPath(project, cache.getStoreValue(InputCache.KEY_PROPERTY)));
        
        new RunXsltJob(desc).schedule();
    }
    
}
