package jp.gr.java_conf.ykhr.eclipse.plugin.jdcounter.vo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;


public class CountVo {
    
    private ICompilationUnit cu;
    private String name;
    
    private int javadocLines;
    private int totalJavadocLines;
    
    private int methodsJavadocLines;
    private List methods = new ArrayList();
    private int fieldsJavadocLines;
    private int fieldNum;
    private List fields = new ArrayList();
    
    public CountVo(ICompilationUnit compUnit) {
        this.cu = compUnit;
        this.name = compUnit.getResource().getLocation().toOSString();
    }
    
    public void addMethod(CountElementVo element) {
        methods.add(element);
        methodsJavadocLines += element.getJavadocLine();
    }
    
    public void addField(CountElementVo element) {
        fields.add(element);
        fieldsJavadocLines += element.getJavadocLine();
        fieldNum += element.getNum();
    }
    
    public void setJavadocLines(int javadocLines) {
        this.javadocLines = javadocLines;
    }
    
    public void setTotalJavadocLines(int totalJavadocLines) {
        this.totalJavadocLines = totalJavadocLines;
    }
    
    public double getMethodAverage() {
        if (methods.size() == 0) {
            return 0;
        }
        return (double) methodsJavadocLines / methods.size();
    }
    
    public double getFieldAverage() {
        if (fields.size() == 0) {
            return 0;
        }
        return (double) fieldsJavadocLines / fieldNum;
    }
    
    public IFile getFile() {
        return (IFile) cu.getResource();
    }
    
    public int getTotalJavadocLines() {
        return totalJavadocLines;
    }

    public int getFieldNum() {
        return fieldNum;
    }

    public List getFields() {
        return fields;
    }

    public int getFieldsJavadocLines() {
        return fieldsJavadocLines;
    }

    public int getJavadocLines() {
        return javadocLines;
    }

    public List getMethods() {
        return methods;
    }

    public int getMethodsJavadocLines() {
        return methodsJavadocLines;
    }

    public String getName() {
        return name;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(1000);
        
        sb.append(name);
        sb.append("\r\n");
        sb.append("  javadocLines:");
        sb.append(javadocLines);
        sb.append("\r\n");
        sb.append("  totalJavadocLines:");
        sb.append(totalJavadocLines);
        sb.append("\r\n");
        
        sb.append("  method average:");
        sb.append(getMethodAverage());
        sb.append("\r\n");

        sb.append("  method:");
        sb.append("\r\n");
        
        for (Iterator iter = methods.iterator(); iter.hasNext(); ) {
            CountElementVo method = (CountElementVo) iter.next();
            sb.append("    ");
            sb.append(method.getName());

            sb.append(" - javadocLines:");
            sb.append(method.getJavadocLine());
            sb.append("\r\n");
        }
        
        
        sb.append("  field average:");
        sb.append(getFieldAverage());
        sb.append("\r\n");
        
        sb.append("  field:");
        sb.append("\r\n");
        
        for (Iterator iter = fields.iterator(); iter.hasNext(); ) {
            CountElementVo field = (CountElementVo) iter.next();
            sb.append("    ");
            sb.append(field.getName());

            sb.append(" - javadocLines:");
            sb.append(field.getJavadocLine());
            sb.append("\r\n");
        }
        
        return sb.toString();
    }
    

}
