package jp.gr.java_conf.ykhr.listfindbugs;

import java.util.ArrayList;
import java.util.List;

public class DecoratorVo {
    
    private String className;
    private boolean hidden;
    private String simpleName;
    private String[] reports;
    private List<BugPatternVo> bugPatterns = new ArrayList<BugPatternVo>();
    
    public DecoratorVo(String className, String[] reports, boolean hidden) {
        this.className = className;
        this.reports = reports;
        this.hidden = hidden;
        
        this.simpleName = createSimpleName();
    }
    
    public void addBugPattern(BugPatternVo bugPattern) {
        bugPatterns.add(bugPattern);
    }
    
    public List<BugPatternVo> getBugPatterns() {
        return bugPatterns;
    }
    
    public String getClassName() {
        return className;
    }
    
    public String[] getReports() {
        return reports;
    }
    
    public String getSimpleName() {
        return simpleName;
    }
    
    public boolean isHidden() {
        return hidden;
    }
    
    private String createSimpleName() {
        int index = className.lastIndexOf(".");
        if (index < 0) {
            return className;
        }
        return className.substring(index + 1);
    }

}
