/*
 * Decompiled with CFR 0.152.
 */
package jp.xet.eclipse.activitytracker.views;

import jp.xet.eclipse.activitytracker.Activator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

public class UserActivityView
extends ViewPart {
    private Text logText;
    private IAction toggleLoggingAction;
    private IAction clearLogAction;
    private boolean logging;

    public void clearLog() {
        this.logText.setText("");
    }

    public void createPartControl(Composite parent) {
        this.logText = new Text(parent, 778);
        this.logText.setFont(new Font((Device)parent.getDisplay(), "Courier New", 12, 0));
        this.makeActions();
        this.contributeToActionBars();
    }

    public void dispose() {
        this.stopLogging();
        super.dispose();
    }

    public void print(String text) {
        this.logText.append(text);
    }

    public void println(String text) {
        this.logText.append(text);
        this.logText.append("\n");
    }

    public void setFocus() {
        this.logText.setFocus();
    }

    public void startLogging() {
        this.logging = true;
        Activator.getDefault().getListener().setOutput(this);
    }

    public void stopLogging() {
        if (this.logging) {
            Activator.getDefault().getListener().setOutput(null);
            this.logging = false;
        }
    }

    private void contributeToActionBars() {
        this.fillLocalToolBar(this.getViewSite().getActionBars().getToolBarManager());
    }

    private void createCleaLogAction() {
        this.clearLogAction = new Action("CLEAR TEXT", 1){

            public void run() {
                UserActivityView.this.clearLog();
            }
        };
        this.clearLogAction.setText("Clear");
        this.clearLogAction.setToolTipText("Clear User Activity Log");
    }

    private void createToggleLoggingAction() {
        this.toggleLoggingAction = new Action("RUN TEXT", 2){

            public void run() {
                if (this.isChecked()) {
                    UserActivityView.this.startLogging();
                } else {
                    UserActivityView.this.stopLogging();
                }
            }
        };
        this.toggleLoggingAction.setText("Log");
        this.toggleLoggingAction.setToolTipText("Start/Stop User Activity Logging");
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add(this.toggleLoggingAction);
        manager.add(this.clearLogAction);
    }

    private void makeActions() {
        this.createToggleLoggingAction();
        this.createCleaLogAction();
    }
}

