package jp.gr.java_conf.ykhr.eclipse.plugin.autocp;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;


public class EnableAction extends AutoCpAction {
    
    @Override
    protected void doRun(IProject project) throws CoreException {
        if (!project.hasNature(Activator.NATURE_ID)) {
            
            IProjectDescription description = project.getDescription();
            String[] natureIds = description.getNatureIds();
            String[] newNatureIds = new String[natureIds.length + 1];
            System.arraycopy(natureIds, 0, newNatureIds, 0, natureIds.length);
            newNatureIds[natureIds.length] = Activator.NATURE_ID;
            
            description.setNatureIds(newNatureIds);
            project.setDescription(description, null);
        }
    }

}
