package jp.gr.java_conf.ykhr.eclipse.plugin.chocosc;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class CloseNotActiveEditor implements IWorkbenchWindowActionDelegate {
    
    private IWorkbenchWindow window = null;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void run(IAction action) {
        IWorkbenchPage page = window.getActivePage();
        
        List nonActiveEditors = new ArrayList();
        IEditorPart activeEditor = page.getActiveEditor();
        IEditorReference[] editorRefs = page.getEditorReferences();
        
        for (int i = 0; i < editorRefs.length; i++) {
            IEditorPart editor = editorRefs[i].getEditor(false);
            if (editor != activeEditor) {
                nonActiveEditors.add(editorRefs[i]);
            }
        }
        
        IEditorReference[] closeEditors 
            = new IEditorReference[nonActiveEditors.size()];
        nonActiveEditors.toArray(closeEditors);
        page.closeEditors(closeEditors, true);
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

}