package jp.gr.java_conf.ykhr.eclipse.plugin.jdcounter.count4em;

import net.sourceforge.metrics.calculators.Calculator;
import net.sourceforge.metrics.calculators.InvalidSourceException;
import net.sourceforge.metrics.core.Metric;
import net.sourceforge.metrics.core.sources.AbstractMetricSource;

import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class TypeJavadocCalculator extends Calculator {
    
    public TypeJavadocCalculator() {
        super(Constant.TYPE_JDLINE);
    }
    
    public void calculate(AbstractMetricSource source) throws InvalidSourceException {
        if (source.getLevel() != TYPE) {
            throw new IllegalArgumentException();
        }
        
        CompilationUnit cu = source.getParsedCompilationUnit();
        AbstractTypeDeclaration type = (AbstractTypeDeclaration) source.getASTNode();
        int typeLine = Utils.getLineLength(cu, type.getJavadoc());
        source.setValue(new Metric(Constant.TYPE_JDLINE, typeLine));
    }
    
}
