package jp.gr.java_conf.ykhr.eclipse.plugin.jdcounter.view.column;

import java.text.DecimalFormat;

import org.eclipse.swt.SWT;

import jp.gr.java_conf.ykhr.eclipse.plugin.jdcounter.Messages;
import jp.gr.java_conf.ykhr.eclipse.plugin.jdcounter.vo.CountVo;

public class FieldAverageColumn implements JavadocColumn {
    
    private static DecimalFormat densityFormat = new DecimalFormat("#.##");
    
    public String getColumnText() {
        return Messages.ViewColumn_FieldAverage;
    }
    
    public String getText(CountVo vo) {
        return densityFormat.format(vo.getFieldAverage());
    }
    
    public int getWidth() {
        return 80;
    }
    
    public int getStyle() {
        return SWT.RIGHT;
    }

}
