package jp.gr.java_conf.ykhr.eclipse.plugin.warninger.core.builder;

import java.util.List;
import java.util.Map;

import jp.gr.java_conf.ykhr.eclipse.plugin.warninger.core.Activator;
import jp.gr.java_conf.ykhr.eclipse.plugin.warninger.core.IWarningerAction;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class WarningerCoreBuilder extends IncrementalProjectBuilder {

    public static final String BUILDER_ID = "jp.gr.java_conf.ykhr.eclipse.plugin.warninger.core.warningerBuilder";
    
    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (kind != FULL_BUILD) {
            IResourceDelta delta = getDelta(getProject());
            if (delta != null) {
                final IFile editingFile = getEditingFile();
                
                delta.accept(new IResourceDeltaVisitor() {
                    public boolean visit(IResourceDelta delta) throws CoreException {
                        IResource resource = delta.getResource();
                        if (resource instanceof IFile) {
                            if (resource.equals(editingFile)) {
                                processAction((IFile) resource);
                                return false;
                            }
                        }
                        return true;
                    }
                });
            }
        }
        
        return null;
    }
    
    private void processAction(IFile resource) throws CoreException {
        List<IWarningerAction> actions = Activator.getDefault().getWarningerActions();
        for (IWarningerAction action : actions) {
            if (action.isTarget(resource)) {
                action.doAction(resource);
            }
        }
    }

    private IFile getEditingFile() {
        IWorkbenchWindow window = getWorkbenchWindow();
        if (window == null) {
            return null;
        }
        
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        
        IEditorPart activeEditor = page.getActiveEditor();
        if (activeEditor == null) {
            return null;
        }
        
        IFile resource = (IFile) activeEditor.getEditorInput().getAdapter(IResource.class);
        return resource;
    }

    private IWorkbenchWindow getWorkbenchWindow() {
        WindowRunnable runnable = new WindowRunnable();
        Display.getDefault().syncExec(runnable);
        return runnable.getWorkbenchWindow();
    }
    
    private static class WindowRunnable implements Runnable {
        private IWorkbenchWindow window = null;
        public void run() {
            window = Activator.getActiveWorkbenchWindow();
        }
        public IWorkbenchWindow getWorkbenchWindow() {
            return window;
        }
    }
    
}
