/*  _______         ____    __         ___    ___
 * \    _  \       \    /  \  /       \   \  /   /       '   '  '
 *  |  | \  \       |  |    ||         |   \/   |         .      .
 *  |  |  |  |      |  |    ||         ||\  /|  |
 *  |  |  |  |      |  |    ||         || \/ |  |         '  '  '
 *  |  |  |  |      |  |    ||         ||    |  |         .      .
 *  |  |_/  /        \  \__//          ||    |  |
 * /_______/ynamic    \____/niversal  /__\  /____\usic   /|  .  . ibliotheque
 *                                                      /  \
 *                                                     / .  \
 * loadoldpsm.c - Code to read a ProTracker Studio    / / \  \
 *                file, opening and closing it for   | <  /   \_
 *                you.                               |  \/ /\   /
 *                                                    \_  /  > /
 * By Chris Moeller.                                    | \ / /
 *                                                      |  ' /
 *                                                       \__/
 */

#include "dumb.h"
#include "internal/it.h"



/* dumb_load_old_psm_quick(): loads an old PSM file into a DUH struct,
 * returning a pointer to the DUH struct. When you have finished with it,
 * you must pass the pointer to unload_duh() so that the memory can be
 * freed.
 */
DUH *DUMBEXPORT dumb_load_old_psm_quick(const char *filename)
{
	DUH *duh;
	DUMBFILE *f = dumbfile_open(filename);

	if (!f)
		return NULL;

	duh = dumb_read_old_psm_quick(f);

	dumbfile_close(f);

	return duh;
}
