#============================================================================================================
#
#	ǗZLeBǗW[
#	-------------------------------------------------------------------------------------
#	̃W[͊ǗCGĨZLeBǗ܂B
#	ȉ3̃pbP[Wɂč\܂
#
#	GLORFINDEL	: [UǗ
#	GILDOR		: O[vǗ
#	ARWEN		: ZLeBC^tFCX
#
#============================================================================================================

#============================================================================================================
#
#	[UǗpbP[W
#
#============================================================================================================
package	GLORFINDEL;

use strict;
#use warnings;

#------------------------------------------------------------------------------------------------------------
#
#	RXgN^
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	W[IuWFNg
#
#------------------------------------------------------------------------------------------------------------
sub new
{
	my $class = shift;
	
	my $obj = {
		'NAME'	=> undef,
		'PASS'	=> undef,
		'FULL'	=> undef,
		'EXPL'	=> undef,
		'SYSAD'	=> undef,
	};
	
	bless $obj, $class;
	
	return $obj;
}

#------------------------------------------------------------------------------------------------------------
#
#	[Uǂݍ
#	-------------------------------------------------------------------------------------
#	@param	$Sys	MELKOR
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Load
{
	my $this = shift;
	my ($Sys) = @_;
	
	# nbV
	$this->{'NAME'} = {};
	$this->{'PASS'} = {};
	$this->{'FULL'} = {};
	$this->{'EXPL'} = {};
	$this->{'SYSAD'} = {};
	
	my $path = '.' . $Sys->Get('INFO') . '/users.cgi';
	
	if (open(my $fh, '<', $path)) {
		flock($fh, 2);
		my @lines = <$fh>;
		close($fh);
		map { s/[\r\n]+\z// } @lines;
		
		foreach (@lines) {
			next if ($_ eq '');
			
			my @elem = split(/<>/, $_, -1);
			if (scalar(@elem) < 6) {
				warn "invalid line in $path";
				next;
			}
			
			my $id = $elem[0];
			$this->{'NAME'}->{$id} = $elem[1];
			$this->{'PASS'}->{$id} = $elem[2];
			$this->{'FULL'}->{$id} = $elem[3];
			$this->{'EXPL'}->{$id} = $elem[4];
			$this->{'SYSAD'}->{$id} = $elem[5];
		}
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	[Uۑ
#	-------------------------------------------------------------------------------------
#	@param	$Sys	MELKOR
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Save
{
	my $this = shift;
	my ($Sys) = @_;
	
	my $path = '.' . $Sys->Get('INFO') . '/users.cgi';
	
	if (open(my $fh, (-f $path ? '+<' : '>'), $path)) {
		flock($fh, 2);
		binmode($fh);
		seek($fh, 0, 0);
		
		foreach (keys %{$this->{'NAME'}}) {
			my $data = join('<>',
				$_,
				$this->{'NAME'}->{$_},
				$this->{'PASS'}->{$_},
				$this->{'FULL'}->{$_},
				$this->{'EXPL'}->{$_},
				$this->{'SYSAD'}->{$_}
			);
			
			print $fh "$data\n";
		}
		
		truncate($fh, tell($fh));
		close($fh);
		chmod $Sys->Get('PM-ADM'), $path;
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	[UIDZbg擾
#	-------------------------------------------------------------------------------------
#	@param	$kind	
#	@param	$name	[h
#	@param	$pBuf	IDZbgi[obt@
#	@return	L[Zbg
#
#------------------------------------------------------------------------------------------------------------
sub GetKeySet
{
	my $this = shift;
	my ($kind, $name, $pBuf) = @_;
	
	my $n = 0;
	
	if ($kind eq 'ALL') {
		$n += push @$pBuf, keys %{$this->{'NAME'}};
	}
	else {
		foreach my $key (keys %{$this->{$kind}}) {
			if ($this->{$kind}->{$key} eq $name || $kind eq 'ALL') {
				$n += push @$pBuf, $key;
			}
		}
	}
	
	return $n;
}

#------------------------------------------------------------------------------------------------------------
#
#	[U擾
#	-------------------------------------------------------------------------------------
#	@param	$kind		
#	@param	$key		[UID
#	@param	$default	ftHg
#	@return	[U
#
#------------------------------------------------------------------------------------------------------------
sub Get
{
	my $this = shift;
	my ($kind, $key, $default) = @_;
	
	my $val = $this->{$kind}->{$key};
	
	return (defined $val ? $val : (defined $default ? $default : undef));
}

#------------------------------------------------------------------------------------------------------------
#
#	[Uǉ
#	-------------------------------------------------------------------------------------
#	@param	$name	
#	@param	$pass	[UID
#	@param	$full	
#	@param	$explan	
#	@param	$sysad	Ǘ҃tO
#	@return	[UID
#
#------------------------------------------------------------------------------------------------------------
sub Add
{
	my $this = shift;
	my ($name, $pass, $full, $explan, $sysad) = @_;
	
	my $id = time;
	$this->{'NAME'}->{$id} = $name;
	$this->{'PASS'}->{$id} = $this->GetStrictPass($pass, $id);
	$this->{'EXPL'}->{$id} = $explan;
	$this->{'FULL'}->{$id} = $full;
	$this->{'SYSAD'}->{$id} = $sysad;
	
	return $id;
}

#------------------------------------------------------------------------------------------------------------
#
#	[Uݒ
#	-------------------------------------------------------------------------------------
#	@param	$id		[UID
#	@param	$kind	
#	@param	$val	ݒl
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Set
{
	my $this = shift;
	my ($id, $kind, $val) = @_;
	
	if (exists $this->{$kind}->{$id}) {
		if ($kind eq 'PASS') {
			$val = $this->GetStrictPass($val, $id);
		}
		$this->{$kind}->{$id} = $val;
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	[U폜
#	-------------------------------------------------------------------------------------
#	@param	$id		폜[UID
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Delete
{
	my $this = shift;
	my ($id) = @_;
	
	delete $this->{'NAME'}->{$id};
	delete $this->{'PASS'}->{$id};
	delete $this->{'FULL'}->{$id};
	delete $this->{'EXPL'}->{$id};
	delete $this->{'SYSAD'}->{$id};
}

#------------------------------------------------------------------------------------------------------------
#
#	ÍpX擾
#	-------------------------------------------------------------------------------------
#	@param	$pass	pX[h
#	@param	$key	pX[hϊL[
#	@return	ÍꂽpXR[h
#
#------------------------------------------------------------------------------------------------------------
sub GetStrictPass
{
	my $this = shift;
	my ($pass, $key) = @_;
	
	my $hash;
	
	if (length($pass) >= 9) {
		require Digest::SHA::PurePerl;
		Digest::SHA::PurePerl->import( qw(sha1_base64) );
		$hash = substr(crypt($key, 'ZC'), -2);
		$hash = substr(sha1_base64("ZeroChPlus_${hash}_$pass"), 0, 10);
	}
	else {
		$hash = substr(crypt($pass, substr(crypt($key, 'ZC'), -2)), -10);
	}
	
	return $hash;
}


#============================================================================================================
#
#	O[vǗpbP[W
#
#============================================================================================================
package	GILDOR;

use strict;
#use warnings;

#------------------------------------------------------------------------------------------------------------
#
#	RXgN^
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	W[IuWFNg
#
#------------------------------------------------------------------------------------------------------------
sub new
{
	my $class = shift;
	
	my $obj = {
		'NAME'	=> undef,
		'EXPL'	=> undef,
		'AUTH'	=> undef,
		'USERS'	=> undef,
	};
	
	bless $obj, $class;
	
	return $obj;
}

#------------------------------------------------------------------------------------------------------------
#
#	O[vǂݍ
#	-------------------------------------------------------------------------------------
#	@param	$Sys	MELKOR
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Load
{
	my $this = shift;
	my ($Sys) = @_;
	
	# nbV
	$this->{'NAME'} = {};
	$this->{'EXPL'} = {};
	$this->{'AUTH'} = {};
	$this->{'USERS'} = {};
	
	my $path = $Sys->Get('BBSPATH') . '/' .  $Sys->Get('BBS') . '/info/groups.cgi';
	
	if (open(my $fh, '<', $path)) {
		flock($fh, 2);
		my @lines = <$fh>;
		close($fh);
		map { s/[\r\n]+\z// } @lines;
		
		foreach (@lines) {
			next if ($_ eq '');
			
			my @elem = split(/<>/, $_, -1);
			if (scalar(@elem) < 5) {
				warn "invalid line in $path";
				next;
			}
			
			my $id = $elem[0];
			$elem[4] =~ s/ //g;
			$this->{'NAME'}->{$id} = $elem[1];
			$this->{'EXPL'}->{$id} = $elem[2];
			$this->{'AUTH'}->{$id} = $elem[3];
			$this->{'USERS'}->{$id} = $elem[4];
		}
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	O[vۑ
#	-------------------------------------------------------------------------------------
#	@param	$Sys	MELKOR
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Save
{
	my $this = shift;
	my ($Sys) = @_;
	
	my $path = $Sys->Get('BBSPATH') . '/' .  $Sys->Get('BBS') . '/info/groups.cgi';
	
	if (open(my $fh, (-f $path ? '+<' : '>'), $path)) {
		flock($fh, 2);
		seek($fh, 0, 0);
		binmode($fh);
		
		foreach (keys %{$this->{'NAME'}}) {
			my $data = join('<>',
				$_,
				$this->{'NAME'}->{$_},
				$this->{'EXPL'}->{$_},
				$this->{'AUTH'}->{$_},
				$this->{'USERS'}->{$_}
			);
			
			print $fh "$data\n";
		}
		
		truncate($fh, tell($fh));
		close($fh);
	}
	chmod $Sys->Get('PM-ADM'), $path;
}

#------------------------------------------------------------------------------------------------------------
#
#	O[vIDZbg擾
#	-------------------------------------------------------------------------------------
#	@param	$pBuf	IDZbgi[obt@
#	@return	O[vID
#
#------------------------------------------------------------------------------------------------------------
sub GetKeySet
{
	my $this = shift;
	my ($pBuf) = @_;
	
	my $n += push @$pBuf, keys %{$this->{'NAME'}};
	
	return $n;
}

#------------------------------------------------------------------------------------------------------------
#
#	O[v擾
#	-------------------------------------------------------------------------------------
#	@param	$kind		
#	@param	$key		O[vID
#	@param	$default	ftHg
#	@return	O[v
#
#------------------------------------------------------------------------------------------------------------
sub Get
{
	my $this = shift;
	my ($kind, $key, $default) = @_;
	
	my $val = $this->{$kind}->{$key};
	
	return (defined $val ? $val : (defined $default ? $default : undef));
}

#------------------------------------------------------------------------------------------------------------
#
#	O[vǉ
#	-------------------------------------------------------------------------------------
#	@param	$name		
#	@param	$explan		
#	@param	$authors	Zbg
#	@param	$users		[UZbg
#	@return	O[vID
#
#------------------------------------------------------------------------------------------------------------
sub Add
{
	my $this = shift;
	my ($name, $explan, $authors, $users) = @_;
	
	my $id = time;
	$this->{'NAME'}->{$id} = $name;
	$this->{'EXPL'}->{$id} = $explan;
	$this->{'AUTH'}->{$id} = $authors;
	$this->{'USERS'}->{$id} = $users;
	
	return $id;
}

#------------------------------------------------------------------------------------------------------------
#
#	O[v[Uǉ
#	-------------------------------------------------------------------------------------
#	@param	$id		O[vID
#	@param	$user	ǉ[UID
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub AddUser
{
	my $this = shift;
	my ($id, $user) = @_;
	
	my @users = split(/\,/, $this->{'USERS'}->{$id});
	my @match = grep($user, @users);
	
	# o^ς݂̃[U͏do^Ȃ
	if (scalar(@match)) {
		$this->{'USERS'}->{$id} .= ",$user";
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	O[vݒ
#	-------------------------------------------------------------------------------------
#	@param	$id		O[vID
#	@param	$kind	
#	@param	$val	ݒl
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Set
{
	my $this = shift;
	my ($id, $kind, $val) = @_;
	
	if (exists $this->{$kind}->{$id}) {
		$this->{$kind}->{$id} = $val;
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	O[v폜
#	-------------------------------------------------------------------------------------
#	@param	$id		폜O[vID
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Delete
{
	my $this = shift;
	my ($id) = @_;
	
	delete $this->{'NAME'}->{$id};
	delete $this->{'EXPL'}->{$id};
	delete $this->{'AUTH'}->{$id};
	delete $this->{'USERS'}->{$id};
}

#------------------------------------------------------------------------------------------------------------
#
#	[UO[v擾
#	-------------------------------------------------------------------------------------
#	@param	$id		[UID
#	@return	[UĂO[vID
#
#------------------------------------------------------------------------------------------------------------
sub GetBelong
{
	my $this = shift;
	my ($id) = @_;
	
	my $Users = $this->{'USERS'};
	foreach my $group (keys %$Users) {
		my @users = split(/\,/, $Users->{$group});
		foreach my $user (@users) {
			if ($id eq $user) {
				return $group;
			}
		}
	}
	
	return '';
}


#============================================================================================================
#
#	ZLeBǗpbP[W
#	ARWEN
#	-------------------------------------------------------------------------------------
#	2004.02.07 start
#
#============================================================================================================
package ARWEN;

use strict;
#use warnings;

#------------------------------------------------------------------------------------------------------------
#
#	RXgN^
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	W[IuWFNg
#
#------------------------------------------------------------------------------------------------------------
sub new
{
	my $class = shift;
	
	my $obj = {
		'SYS'	=> undef,
		'USER'	=> undef,
		'GROUP'	=> undef,
		'BBS'	=> undef,
	};
	bless $obj, $class;
	
	return $obj;
}

#------------------------------------------------------------------------------------------------------------
#
#	
#	-------------------------------------------------------------------------------------
#	@param	$Sys	MELKOR
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Init
{
	my $this = shift;
	my ($Sys) = @_;
	
	$this->{'SYS'} = $Sys;
	
	# 2d[hh~
	if (! defined $this->{'USER'}) {
		$this->{'USER'} = new GLORFINDEL;
		$this->{'GROUP'} = new GILDOR;
		$this->{'USER'}->Load($Sys);
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	OC
#	-------------------------------------------------------------------------------------
#	@param	$name	[U
#	@param	$pass	pX[h
#	@return	ȃ[UȂ1Ԃ
#
#------------------------------------------------------------------------------------------------------------
sub IsLogin
{
	my $this = shift;
	my ($name, $pass) = @_;
	
	my $User = $this->{'USER'};
	
	# [UŃ[UIDZbg擾
	my @keySet = ();
	$User->GetKeySet('NAME', $name, \@keySet);
	
	# 擾IDZbg烆[UƃpX[ĥ
	foreach my $id (@keySet) {
		my $lPass = $User->Get('PASS', $id);
		my $hash = $User->GetStrictPass($pass, $id);
		if ($lPass eq $hash) {
			return $id;
		}
	}
	return 0;
}

#------------------------------------------------------------------------------------------------------------
#
#	OO[v񏀔
#	-------------------------------------------------------------------------------------
#	@param	$bbs	K
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub SetGroupInfo
{
	my $this = shift;
	my ($bbs) = @_;
	
	my $oldBBS = $this->{'SYS'}->Get('BBS');
	$this->{'SYS'}->Set('BBS', $bbs);
	$this->{'BBS'} = $bbs;
	
	$this->{'GROUP'}->Load($this->{'SYS'});
	
	$this->{'SYS'}->Set('BBS', $oldBBS);
}

#------------------------------------------------------------------------------------------------------------
#
#	
#	-------------------------------------------------------------------------------------
#	@param	$id		[UID
#	@param	$author	
#	@param	$bbs	K
#	@return	[UĂ1Ԃ
#
#------------------------------------------------------------------------------------------------------------
sub IsAuthority
{
	my $this = shift;
	my ($id, $author, $bbs) = @_;
	
	# VXeǗO[vȂ疳OK
	my $sysad = $this->{'USER'}->Get('SYSAD', $id);
	return 1 if ($sysad);
	return 0 if ($bbs eq '*');
	
	# ΏBBSɏĂ邩mF
	my $group = $this->{'GROUP'}->GetBelong($id);
	return 0 if ($group eq '');;
	
	# Ă邩mF
	my $auth = $this->{'GROUP'}->Get('AUTH', $group);
	my @authors = split(/\,/, $auth, -1);
	foreach my $auth (@authors) {
		if ($auth eq $author) {
			return 1;
		}
	}
	
	return 0;
}

#------------------------------------------------------------------------------------------------------------
#
#	fXg擾
#	-------------------------------------------------------------------------------------
#	@param	$id		[UID
#	@param	$oBBS	NAZGULIuWFNg
#	@param	$pBBS	ʊi[pz̎Q
#	@return	f
#
#------------------------------------------------------------------------------------------------------------
sub GetBelongBBSList
{
	my $this = shift;
	my ($id, $oBBS, $pBBS) = @_;
	
	my $n = 0;
	
	# VXeǗ[U͑SĂBBSɏƂ
	if ($this->{'USER'}->Get('SYSAD', $id)) {
		$oBBS->GetKeySet('ALL', '', $pBBS);
		$n = scalar @$pBBS;
	}
	# ʃ[U͏O[v画f
	else {
		my $origBBS = $this->{'BBS'};
		my @keySet = ();
		$oBBS->GetKeySet('ALL', '', \@keySet);
		
		foreach my $bbsID (@keySet) {
			my $bbsDir = $oBBS->Get('DIR', $bbsID);
			SetGroupInfo($this, $bbsDir);
			if ($this->{'GROUP'}->GetBelong($id) ne '') {
				$n += push @$pBBS, $bbsID;
			}
		}
		
		# ㏈
		if (defined $origBBS) {
			SetGroupInfo($this, $origBBS);
		}
	}
	return $n;
}

#============================================================================================================
#	Module END
#============================================================================================================
1;
