#============================================================================================================
#
#	g@\ - n\vOC
#	0ch_area.pl
#
#	by 낿˂vX
#	http://zerochplus.sourceforge.jp/
#
#	  O  K  r e a d m e . t x t         B
#	ǂ܂ȂƂȂ͖̒   Q       B
#
#	---------------------------------------------------------------------------
#
#	2011.03.19 start
#
#============================================================================================================
package ZPL_area;

#------------------------------------------------------------------------------------------------------------
#	RXgN^
#------------------------------------------------------------------------------------------------------------
sub new
{
	my $this = shift;
	my ($Config) = @_;
	my ($obj);
	
	$obj = {};
	bless $obj, $this;
	
	if (defined $Config) {
		$obj->{'PLUGINCONF'} = $Config;
		$obj->{'is0ch+'} = 1;
	}
	else {
		$obj->{'CONFIG'} = $this->getConfig();
		$obj->{'is0ch+'} = 0;
	}
	
	return $obj;
}

#------------------------------------------------------------------------------------------------------------
#	g@\̎擾
#	-------------------------------------------------------------------------------------
#	@return	̕
#------------------------------------------------------------------------------------------------------------
sub getName
{
	my	$this = shift;
	return 'n\vOC';
}

#------------------------------------------------------------------------------------------------------------
#	g@\擾
#	-------------------------------------------------------------------------------------
#	@return	
#------------------------------------------------------------------------------------------------------------
sub getExplanation
{
	my	$this = shift;
	return 'Oreadme.txtǂłˁ';
}

#------------------------------------------------------------------------------------------------------------
#	g@\^Cv擾
#	-------------------------------------------------------------------------------------
#	@return	g@\^Cv(X:1, X:2, read:4, index:8, ݑO:16)
#------------------------------------------------------------------------------------------------------------
sub getType
{
	my	$this = shift;
	return (16);
}

#------------------------------------------------------------------------------------------------------------
#	ݒ胊Xg擾 (0ch+ Only)
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	ݒnbVt@X
#		\%config = (
#			'ݒ薼'	=> {
#				'default'		=> l,			# ^Ul̏ꍇ on/true: 1, off/false: 0
#				'valuetype'		=> l̃^Cv,		# l: 1, : 2, ^Ul: 3
#				'description'	=> 'ݒ̐',	# Ă\܂
#			},
#		);
#------------------------------------------------------------------------------------------------------------
sub getConfig
{
	my	$this = shift;
	my	%config;
	
	%config = (
		'bbs'	=> {
			'default'		=> 'testing,testingx',
			'valuetype'		=> 2,
			'description'	=> '삳(u,v؂ŕw)',
		},
		'key1'	=> {
			'default'		=> '',
			'valuetype'		=> 2,
			'description'	=> 'APIL[1',
		},
		'key2'	=> {
			'default'		=> '',
			'valuetype'		=> 2,
			'description'	=> 'APIL[2',
		},
		'cache'	=> {
			'default'		=> 50,
			'valuetype'		=> 1,
			'description'	=> 'LbVۑ',
		},
	);
	
	return \%config;
}

#------------------------------------------------------------------------------------------------------------
#	g@\sC^tFCX
#	-------------------------------------------------------------------------------------
#	@param	$sys	MELKOR
#	@param	$form	SAMWISE
#	@param	$type	s^Cv
#	@return	Ȉꍇ0
#------------------------------------------------------------------------------------------------------------
sub execute
{
	my	$this = shift;
	my	($sys, $form, $type) = @_;
	my	($flag, $name, $ip, $area, $prefcode);
	
	# 삳w
	$flag = 0;
	foreach ( split( /,/, $this->GetConf('bbs') ) ) {
		$flag = 1 if( $_ eq $sys->Get('BBS') );
	}
	return 0 if ( !$flag );
	
	# n\Ȃɂ
	if ( HiddenArea( $form ) ) {
		return 0;
	}
	
	# IPAhX
	$ip = $ENV{'REMOTE_ADDR'};
	$host = $form->Get('HOST');
	
	# LbV
	$area = CacheSearch($ip, $host);
	if ( $area ) {
		SetArea( $sys, $form, $area );
		return 0;
	}
	
	# APIŎĂ
	( $area, $prefcode ) = GetArea($this->GetConf('key1'),$this->GetConf('key2'),$ip);
	
	# s{R[h->s{ϊ
	$area = ConvPref($prefcode) if ( $area eq "{" );
	
	# OɃZbg
	SetArea( $sys, $form, $area );
	
	# LbVۑ
	CacheSave( $ip, $area, $this->GetConf('cache') );
	
	return 0;
}

#------------------------------------------------------------------------------------------------------------
#	n\
#	-------------------------------------------------------------------------------------
#	@param	$form	SAMWISE
#	@return	\Ȃ1 \Ȃ0
#------------------------------------------------------------------------------------------------------------
sub HiddenArea
{
	
	my ( $form ) = @_;
	my ( $mail );
	
	# [擾
	$mail = $form->Get('mail');
	
	# [ !hidden ܂܂Ăn\Ȃ
	if ( $mail =~ /!hidden/ ) {
		$mail =~ s/!hidden//; # S~
		$form->Set('mail', $mail);
		return 1;
	}
	
	return 0;
	
}

#------------------------------------------------------------------------------------------------------------
#	LbVۑp
#	-------------------------------------------------------------------------------------
#	@param	$ip		IPAhX
#			$area	\n
#	@return	Ȃ
#------------------------------------------------------------------------------------------------------------
sub CacheSave
{
	
	my ( $ip, $area, $log ) = @_;
	my ( @cache );
	
	if ( open( CACHE, "< ./info/area_cache.cgi") ) {
		@cache = <CACHE>;
		close CACHE;
	}
	# LbVۑ𒴂Ă
	shift @cache if ( $log - 2 < $#cache );
	push (@cache, "$ip<>$area\n" );
	if ( open( CACHE, "> ./info/area_cache.cgi") ) {
		print CACHE @cache;
		close CACHE;
	}

}

#------------------------------------------------------------------------------------------------------------
#	LbV
#	-------------------------------------------------------------------------------------
#	@param	$ip		IPAhX
#	@return	s{/ LbVȂ/s̏ꍇ 0
#------------------------------------------------------------------------------------------------------------
sub CacheSearch
{
	
	my ( $ip, $host ) = @_;
	my ( $shos, $area );
	
	# w胊Xg
	if ( open( CACHE, "< ./info/area_list.cgi") ) {
		while ( <CACHE> ) {
			( $shos, $area ) = split( /<>/, $_ );
			if ( $host =~ /$shos/ ) {
				chomp($area);
				return $area;
			}
		}
	}
	
	# LbV
	if ( open( CACHE, "< ./info/area_cache.cgi") ) {
		while ( <CACHE> ) {
			return $1 if ( $_ =~ /^$ip<>(.+)\n$/ )
		}
	}
	
	return 0;
	
}

#------------------------------------------------------------------------------------------------------------
#	API擾
#	-------------------------------------------------------------------------------------
#	@param	$ip		IPAhX
#	@return	$country	
#			$prefcode	ISO 3166-2:JPɊÂs{R[h
#------------------------------------------------------------------------------------------------------------
sub GetArea
{
	
	my ( $key1, $key2, $ip ) = @_;
	my ( $url, $proxy, $req, $res, $cont, $code, $xml, $contry, $prefcode );
	
	use LWP::UserAgent;
	use XML::Simple;
	use Encode;
	
	# APIANZXpURL
	$url = "http://api.docodoco.jp/v3/search?key1=$key1&key2=$key2&format=xml&charset=utf8&ipadr=$ip";
	
	# O
	$proxy = new LWP::UserAgent;
	$proxy->agent('Mozilla/5.0 (Windows NT 6.1; rv:2.0) Gecko/20100101 Firefox/4.0');
	$proxy->timeout(5);
	
	# Ă܂
	$req = HTTP::Request->new('GET', $url);
	$res = $proxy->request($req);
	$cont = $res->content;
	$code = $proxy->request($req)->code;
	
	# 擾łȂ
	return -1 if ( $code ne 200 );
	
	# XMLp[X
	$xml = XMLin($cont);
	
	# GR[hȂ
	$country = Encode::from_to($xml->{'CountryJName'}, 'utf8', 'sjis');
	$prefcode = $xml->{'PrefCode'};
	
	return ( $country, $prefcode );
	
}

#------------------------------------------------------------------------------------------------------------
#	ISO 3166-2:JP -> 
#	-------------------------------------------------------------------------------------
#	@param	$prefcode	ISO 3166-2:JPɊÂs{R[h
#	@return	s{
#------------------------------------------------------------------------------------------------------------
sub ConvPref
{
	
	my ($prefcode) = @_;
	
	my @JP = (
		'kC', 'X', '茧', '{錧', 'Hc', 'R`',
		'', '錧', 'Ȗ،', 'Qn', 'ʌ', 't',
		's', '_ސ쌧', 'V', 'xR', 'ΐ쌧', '䌧',
		'R', '쌧', '򕌌', 'É', 'm', 'Od',
		'ꌧ', 's{', '{', 'Ɍ', 'ޗǌ', 'a̎R',
		'挧', '', 'R', 'L', 'R', '',
		'쌧', 'Q', 'm', '', 'ꌧ', '茧',
		'F{', '啪', '{茧', '', 'ꌧ',
	);
	
	return $JP[$prefcode-1];
	
}

#------------------------------------------------------------------------------------------------------------
#	n\Zbg
#	-------------------------------------------------------------------------------------
#	@param	$sys	MELKOR
#			$form	SAMWISE
#			$area	\n
#	@return	Ȃ
#------------------------------------------------------------------------------------------------------------
sub SetArea
{
	
	my ( $sys, $form, $area ) = @_;
	my ( $name );
	
	require './module/isildur.pl';
	my $SET = ISILDUR->new;
	$SET->Load($sys);
	
	$name = ($form->Get('FROM')||$SET->Get('BBS_NONAME_NAME'));
	
	$form->Set('FROM', $name."</b>(".$area.")<b>");
	
}


#------------------------------------------------------------------------------------------------------------
#	ݒl擾 (0ch+ Only)
#	-------------------------------------------------------------------------------------
#	@param	$key	ݒ薼
#	@return	ݒl
#------------------------------------------------------------------------------------------------------------
sub GetConf
{
	my	$this = shift;
	my	($key) = @_;
	my	($val);
	
	if ($this->{'is0ch+'}) {
		$val = $this->{'PLUGINCONF'}->GetConfig($key);
	}
	else {
		if (defined $this->{'CONFIG'}->{$key}) {
			$val = $this->{'CONFIG'}->{$key}->{'default'};
		}
		else {
			$val = undef;
		}
	}
	
	return $val;
}

#------------------------------------------------------------------------------------------------------------
#	ݒlݒ (0ch+ Only)
#	-------------------------------------------------------------------------------------
#	@param	$key	ݒ薼
#	@param	$val	ݒl
#	@return	Ȃ
#------------------------------------------------------------------------------------------------------------
sub SetConf
{
	my	$this = shift;
	my	($key, $val) = @_;
	
	if ($this->{'is0ch+'}) {
		$this->{'PLUGINCONF'}->SetConfig($key, $val);
	}
	else {
		if (defined $this->{'CONFIG'}->{$key}) {
			$this->{'CONFIG'}->{$key}->{'default'} = $val;
		}
		else {
			$this->{'CONFIG'}->{$key} = { 'default' => $val };
		}
	}
}

#============================================================================================================
#	Module END
#============================================================================================================
1;
