#============================================================================================================
#
#	g@\ - Ǝgbv
#	0ch_mytrip.pl
#	---------------------------------------------------------------------------
#	2013.05.07 start
#
#============================================================================================================
package ZPL_mytrip;

#------------------------------------------------------------------------------------------------------------
#	RXgN^
#------------------------------------------------------------------------------------------------------------
sub new
{
	my $class = shift;
	my ($Config) = @_;
	
	my $obj = {};
	bless $obj, $class;
	
	if (defined $Config) {
		$obj->{'PLUGINCONF'} = $Config;
		$obj->{'is0ch+'} = 1;
	}
	else {
		$obj->{'CONFIG'} = $class->getConfig();
		$obj->{'is0ch+'} = 0;
	}
	
	return $obj;
}

#------------------------------------------------------------------------------------------------------------
#	g@\̎擾
#------------------------------------------------------------------------------------------------------------
sub getName
{
	my $this = shift;
	return 'Ǝgbv';
}

#------------------------------------------------------------------------------------------------------------
#	g@\擾
#------------------------------------------------------------------------------------------------------------
sub getExplanation
{
	my $this = shift;
	return '';
}

#------------------------------------------------------------------------------------------------------------
#	g@\^Cv擾
#------------------------------------------------------------------------------------------------------------
sub getType
{
	my $this = shift;
	return (1 | 2);
}

#------------------------------------------------------------------------------------------------------------
#	ݒ胊Xg擾 (0ch+ Only)
#------------------------------------------------------------------------------------------------------------
sub getConfig
{
	my $this = shift;
	my %config = ();
	return \%config;
}

#------------------------------------------------------------------------------------------------------------
#	g@\sC^tFCX
#------------------------------------------------------------------------------------------------------------
sub execute
{
	my $this = shift;
	my ($Sys, $Form, $type) = @_;
	
	if ($type & (1 | 2)) {
		my $name = $Form->Get('FROM');
		
		# xh~
		$name =~ s///g;
		# gbvϊ
		$name =~ s|#(.*)$|' </b>'.MyTrip($1).' <b>'|e;
		
		$Form->Set('FROM', $name);
		
		# ftHg̃gbv𖳌ɂ
		$Form->Set('TRIPKEY', '') if ($this->{'is0ch+'});
	}
	
	return 0;
}

sub MyTrip
{
	my ($key) = @_;
	
	require Digest::SHA::PurePerl;
	Digest::SHA::PurePerl->import(qw(sha1_base64));
	
	# SHA-1Ńgbv𐶐
	my $trip = substr(sha1_base64($key), 0, 12);
	
	# u0-9A-Za-z+/v  u...v
	my %a2h = ();
	@a2h{'0'..'9', 'A'..'Z', 'a'..'z', '+', '/'}
		= map { chr($_>>8).chr($_&0xff) } (0x82B2 .. 0x82F1); # .. (Shift_JIS)
	$trip =~ s/(.)/$a2h{$1}/eg;
	
	return $trip;
}

#------------------------------------------------------------------------------------------------------------
#	ݒl擾 (0ch+ Only)
#------------------------------------------------------------------------------------------------------------
sub GetConf
{
	my $this = shift;
	my ($key) = @_;
	if ($this->{'is0ch+'}) {
		return $this->{'PLUGINCONF'}->GetConfig($key);
	}
	elsif (defined $this->{'CONFIG'}->{$key}) {
		return $this->{'CONFIG'}->{$key}->{'default'};
	}
}

#------------------------------------------------------------------------------------------------------------
#	ݒlݒ (0ch+ Only)
#------------------------------------------------------------------------------------------------------------
sub SetConf
{
	my $this = shift;
	my ($key, $val) = @_;
	if ($this->{'is0ch+'}) {
		$this->{'PLUGINCONF'}->SetConfig($key, $val);
	}
	elsif (defined $this->{'CONFIG'}->{$key}) {
		$this->{'CONFIG'}->{$key}->{'default'} = $val;
	}
	else {
		$this->{'CONFIG'}->{$key} = { 'default' => $val };
	}
}

#============================================================================================================
#	Module END
#============================================================================================================
1;
