#============================================================================================================
#
#	g@\ - NG[h
#	0ch_ngword.pl
#	---------------------------------------------------------------------------
#	2013.05.30 start
#
#============================================================================================================
package ZPL_ngword;

#------------------------------------------------------------------------------------------------------------
#	RXgN^
#------------------------------------------------------------------------------------------------------------
sub new
{
	my $class = shift;
	my ($Config) = @_;
	
	my $obj = {};
	bless $obj, $class;
	
	if (defined $Config) {
		$obj->{'PLUGINCONF'} = $Config;
		$obj->{'is0ch+'} = 1;
	}
	else {
		$obj->{'CONFIG'} = $class->getConfig();
		$obj->{'is0ch+'} = 0;
	}
	
	return $obj;
}

#------------------------------------------------------------------------------------------------------------
#	g@\̎擾
#------------------------------------------------------------------------------------------------------------
sub getName
{
	my $this = shift;
	return 'NG[h';
}

#------------------------------------------------------------------------------------------------------------
#	g@\擾
#------------------------------------------------------------------------------------------------------------
sub getExplanation
{
	my $this = shift;
	return '{▼Oɓ̕񂪊܂܂鏑݂ۂ܂BNG[hłB';
}

#------------------------------------------------------------------------------------------------------------
#	g@\^Cv擾
#------------------------------------------------------------------------------------------------------------
sub getType
{
	my $this = shift;
	return 16;
}

#------------------------------------------------------------------------------------------------------------
#	ݒ胊Xg擾 (0ch+ Only)
#------------------------------------------------------------------------------------------------------------
sub getConfig
{
	my $this = shift;
	my %config = ();
	return \%config;
}

#------------------------------------------------------------------------------------------------------------
#	g@\sC^tFCX
#------------------------------------------------------------------------------------------------------------
sub execute
{
	my $this = shift;
	my ($Sys, $Form, $type) = @_;
	
	if ($type & 16) {
		foreach my $key ('FROM', 'mail', 'MESSAGE') {
			my $text = $Form->Get($key);
			my $reject = 0;
			
			# NG[h𐳋K\Ŕ
			$reject = 1 if ($text =~ /U/);
			$reject = 1 if ($text =~ /pass[0-9]*word/i);
			
			# mail̂
			if ($key eq 'mail') {
				$reject = 1 if ($text =~ /@/);
			}
			
			# {̂
			if ($key eq 'MESSAGE') {
				# Shift_JISoOɒ
				$reject = 1 if ($text =~ /\Q^C}V\E/);
			}
			
			if ($reject) {
				PrintBBSError($Sys, $Form, 600); # $ZP::E_REG_NGWORD == 600
			}
		}
	}
	
	return 0;
}

#------------------------------------------------------------------------------------------------------------
#	ݒl擾 (0ch+ Only)
#------------------------------------------------------------------------------------------------------------
sub GetConf
{
	my $this = shift;
	my ($key) = @_;
	if ($this->{'is0ch+'}) {
		return $this->{'PLUGINCONF'}->GetConfig($key);
	}
	elsif (defined $this->{'CONFIG'}->{$key}) {
		return $this->{'CONFIG'}->{$key}->{'default'};
	}
}

#------------------------------------------------------------------------------------------------------------
#	ݒlݒ (0ch+ Only)
#------------------------------------------------------------------------------------------------------------
sub SetConf
{
	my $this = shift;
	my ($key, $val) = @_;
	if ($this->{'is0ch+'}) {
		$this->{'PLUGINCONF'}->SetConfig($key, $val);
	}
	elsif (defined $this->{'CONFIG'}->{$key}) {
		$this->{'CONFIG'}->{$key}->{'default'} = $val;
	}
	else {
		$this->{'CONFIG'}->{$key} = { 'default' => $val };
	}
}

#------------------------------------------------------------------------------------------------------------
#	Ȃ񂿂bbs.cgiG[y[W\
#------------------------------------------------------------------------------------------------------------
sub PrintBBSError
{
	my ($Sys, $Form, $err) = @_;
	
	require './module/radagast.pl';
	require './module/isildur.pl';
	require './module/thorin.pl';
	require './module/orald.pl';
	
	my $CGI = {};
	$CGI->{'SYS'} = $Sys;
	$CGI->{'FORM'} = $Form;
	$CGI->{'COOKIE'} = RADAGAST->new;
	$CGI->{'COOKIE'}->Init;
	$CGI->{'SET'} = ISILDUR->new;
	$CGI->{'SET'}->Load($Sys);
	
	my $Page = THORIN->new;
	my $Error = ORALD->new;
	$Error->Load($Sys);
	$Error->Print($CGI, $Page, $err, $Sys->Get('AGENT'));
	$Page->Flush('', 0, 0);
	
	exit($err);
}

#============================================================================================================
#	Module END
#============================================================================================================
1;
