#!/usr/bin/perl
use strict;

my $system_dir = './test';
chdir $system_dir;

exit(main());

sub main
{
	print "Content-Type: text/html; charset=Shift_JIS\n\n";
	
	my $bbsmenu = getbbsmenu();
	
	if (! defined $bbsmenu) {
		print "BBSMENU擾s<br>\n";
		return 0;
	}
	
	foreach my $category (@$bbsmenu) {
		print "$category->{name}<br>\n";
		
		foreach my $bbs (@{$category->{list}}) {
			print "E<a href=\"$bbs->{url}\">$bbs->{name}</a><br>\n";
		}
		
		print "<br>\n";
	}
	
	return 0;
}

sub getbbsmenu
{
	require "./module/melkor.pl";
	require "./module/nazguls.pl";
	require "./module/galadriel.pl";
	
	my $SYS = new MELKOR;
	return undef if ($SYS->Init() ne 0);
	
	my $basedir = $SYS->Get('SERVER', '') . GALADRIEL::MakePath($SYS->Get('CGIPATH', ''), $SYS->Get('BBSPATH', ''));
	
	my $BBS = NAZGUL->new;
	$BBS->Load($SYS);
	
	my $Category = ANGMAR->new;
	$Category->Load($SYS);
	
	my @catSet = ();
	$Category->GetKeySet(\@catSet);
	
	my $bbsmenu = [];
	
	foreach my $catid (sort @catSet) {
		my $catData = {};
		
		$catData->{name} = $Category->Get('NAME', $catid);
		
		my $bbslist = [];
		$catData->{list} = $bbslist;
		
		my @bbsSet = ();
		$BBS->GetKeySet('CATEGORY', $catid, \@bbsSet);
		
		foreach my $bbsid (sort @bbsSet) {
			my $bbsData = {};
			
			$bbsData->{name} = $BBS->Get('NAME', $bbsid);
			
			my $bbsDir = $BBS->Get('DIR', $bbsid);
			$bbsData->{dir} = $bbsDir;
			$bbsData->{url} = "$basedir/$bbsDir";
			
			push @$bbslist, $bbsData;
		}
		
		push @$bbsmenu, $catData;
	}
	
	return $bbsmenu;
}

