#!/usr/bin/perl

use strict;
use lib './perllib';
use Module::CoreList;

my $version = $];
my $perlpath = $^X;
my $filename = $ENV{'SCRIPT_FILENAME'} || $0;
my $serverhost = $ENV{'HTTP_HOST'};
my $servername = $ENV{'SERVER_NAME'};
my $core = $Module::CoreList::version{$version};
my @checklist = (qw(
	Encode
	Time::HiRes
	Time::Local
	Socket
), qw(
	Digest::SHA::PurePerl
	Net::DNS
	Net::DNS::Lite
	List::MoreUtils
	LWP::UserAgent
	XML::Simple
), qw(
	Digest::SHA1
	LWP::Simple
	Jcode
));


print "Content-Type: text/html\n\n";

print "<h2>Perl Version</h2>\n";
print "version: $version<br>\n";
print "perlpath: $perlpath<br>\n";
print "filename: $filename<br>\n";
print "serverhost: $serverhost<br>\n";
print "servername: $servername<br>\n";
print "<br><hr>\n";


print "<h2>Check Package (include perllib)</h2>\n";
print "<table>";
print "<tr><th>Package</th><th>Version</th><th>Core</th><th>Directory</th></tr>\n";
foreach my $pkg (@checklist) {
	my @elem = ($pkg, '', '', '');
	
	my $var = eval("
		require $pkg;
		return \${${pkg}::VERSION};
	");
	$var = 'undefined' if ($@ || !defined $var);
	
	if (defined $core->{$pkg}) {
		$elem[1] = ($core->{$pkg} eq $var ? "$var" : "<b>$var</b>");
		$elem[2] = $core->{$pkg};
	} else {
		$elem[1] = "<b>$var</b>";
	}
	
	if (!$@) {
		$_ = $pkg;
		$_ =~ s|::|/|g;
		$elem[3] = $INC{"$_.pm"};
	}
	
	print "<tr><td>$elem[0]</td><td>$elem[1]</td><td>$elem[2]</td><td>$elem[3]</td></tr>\n";
}
print "</table>";
print "<br><hr>\n";


print "<h2>\%ENV</h2>\n";
print "<table>";
foreach my $key (sort grep /^(HTTP|REMOTE|CONTENT|SCRIPT|DOCUMENT|GATEWAY|QUERY|REQUEST|SERVER)_/, keys %ENV) {
	my $str = $ENV{$key};
	$str =~ s/&/&amp;/g;
	$str =~ s/</&lt;/g;
	$str =~ s/>/&gt;/g;
	print "<tr><td>$key</td><td>$str</td></tr>\n";
}
print "</table>";
print "<br><hr>\n";


print "<h2>\@INC</h2>\n";
foreach my $path (sort @INC) {
	print "$path<br>\n";
}
print "<br><hr>\n";


print "<h2>\%INC (loaded)</h2>\n";
print "<table>";
foreach my $key (sort keys %INC) {
	print "<tr><td>$key</td><td>$INC{$key}</td></tr>\n";
}
print "</table>";
print "<br><hr>\n";


print "<h2>CoreList ($version)</h2>\n";
foreach my $module (sort keys %$core) {
	print "$module<br>\n";
}
print "<br><hr>\n";
