#============================================================================================================
#
#	Abvf[gʒm
#
#============================================================================================================

package ZP_NEWRELEASE;

use strict;
use warnings;

use Encode;

#------------------------------------------------------------------------------------------------------------
#
#	W[RXgN^ - new
#	-------------------------------------------
#	@FȂ
#	߂lFW[IuWFNg
#
#------------------------------------------------------------------------------------------------------------
sub new
{
	my $class = shift;
	
	my $obj = {
		'NEWRELEASE'	=> undef,
	};
	
	bless $obj, $class;
	
	return $obj;
}

#------------------------------------------------------------------------------------------------------------
#
#	 - Init
#	-------------------------------------------------------------------------------------
#	@F$Sys : MELKOR
#	߂lF0
#
#------------------------------------------------------------------------------------------------------------
sub Init
{
	my $this = shift;
	my ($Sys) = @_;
	
	$this->{'NEWRELEASE'} = {
		'CheckURL'	=> 'http://zerochplus.sourceforge.jp/Release.txt',
		'Interval'	=> 60 * 60 * 24, # 24
		'RawVer'	=> $Sys->Get('VERSION'),
		'CachePATH'	=>  '.' . $Sys->Get('INFO') . '/Release.cgi',
		'CachePM'	=> $Sys->Get('PM-ADM'),
		'Update'	=> 0,
	};
	
}


#------------------------------------------------------------------------------------------------------------
#
#	XV`FbN - Check
#	-------------------------------------------------------------------------------------
#	@FȂ
#	߂lF0
#
#------------------------------------------------------------------------------------------------------------
sub Check
{
	my $this = shift;
	
	my $hash = $this->{'NEWRELEASE'};
	
	my $url = $hash->{'CheckURL'};
	my $interval = $hash->{'Interval'};
	
	my $rawver = $hash->{'RawVer'};
	my @ver;
	# 0ch+ BBS n.m.r YYYYMMDD `ł邱ƂƊ҂Ă
	# ܂ 0ch+ BBS dev-rREV YYYYMMDD
	if ( $rawver =~ /(\d+(?:\.\d+)+)/ ) {
		@ver = split /\./, $1;
	} elsif ( $rawver =~ /dev-r(\d+)/ ) {
		@ver = ( 'dev', $1 );
	} else {
		@ver = ( 'dev', 0 );
	}
	my $date = '00000000';
	if ( $rawver =~ /(\d{8})/ ) {
		$date = $1;
	}
	
	my $path = $hash->{'CachePATH'};
	
	
	# LbV̗L߂Ăf[^ƂĂ
	if ( !-f $path || ( stat $path )[9] < time - $interval ) {
		# ڑh~݂
		utime ( undef, undef, $path );
		
		require('./module/httpservice.pl');
		
		my $proxy = HTTPSERVICE->new;
		# URLw
		$proxy->setURI($url);
		# UserAgentݒ
		$proxy->setAgent($rawver);
		# ^CAEgݒ
		$proxy->setTimeout(3);
		
		# ƂĂ
		$proxy->request();
		
		# Ƃꂽ
		if ( $proxy->getStatus() eq 200 ) {
			if (open(my $fh, (-f $path ? '+<' : '>'), $path)) {
				flock($fh, 2);
				seek($fh, 0, 0);
				binmode($fh);
				print $fh $proxy->getContent();
				truncate($fh, tell($fh));
				close($fh);
			}
			chmod($hash->{'CachePM'}, $path);
		}
	}
	
	
	# r
	my @release = ();
	
	if (open(my $fh, '<', $path)) {
		flock($fh, 2);
		while ( <$fh> ) {
			# $l =~ s/\x0d?\x0a?$//;
			# samwiseƓ̃Tj^CWOs܂
			$_ =~ s/[\x0d\x0a\0]//g;
			$_ =~ s/"/&quot;/g;
			$_ =~ s/</&lt;/g;
			$_ =~ s/>/&gt;/g;
			
			Encode::from_to( $_, 'utf8', 'sjis' );
			push @release, $_;
		}
		close($fh);
	}
	# e(BOM)
	$release[0] =~ s/^\xef\xbb\xbf//;
	
	# n.m.r`ł邱Ƃ҂Ă
	my @newver = split /\./, $release[0];
	# YYYY.MM.DD`ł邱Ƃ҂Ă
	my $newdate = join '', (split /\./, $release[2], 3);
	
	my $i = 0;
	my $newrelease = 0;
	# o[Wr
	# Ƃ肠verdevȂ疳(̓tŊmF)
	if ( $ver[0] ne 'dev' ) {
		foreach my $nv ( @newver ) {
			my $vv = shift @ver;
			if ( $vv < $nv ) {
				$newrelease = 1;
			} elsif ( $vv > $nv ) {
				# ȂCXg[ς݂̕炵
				last;
			}
		}
	}
	# 悭킩Ȃ炠炽߂ētŊmF
	unless ( $newrelease ) {
		if ( $date < $newdate ) {
			$newrelease = 1;
		}
	}
	
	
	$this->{'NEWRELEASE'}->{'Update'}	= $newrelease;
	$this->{'NEWRELEASE'}->{'Ver'}		= shift @release;
	$this->{'NEWRELEASE'}->{'URL'}		= 'http://sourceforge.jp/projects/zerochplus/releases/' . shift @release;
	$this->{'NEWRELEASE'}->{'Date'}		= shift @release;
	
	shift @release; # 4s(s)
	# c̓[Xm[gƂ̂c
	$this->{'NEWRELEASE'}->{'Detail'}	= \@release;
	
	return 0;

}

#------------------------------------------------------------------------------------------------------------
#
#	ݒl擾 - Get
#	-------------------------------------------------------------------------------------
#	@param	$key	擾L[
#			$default : ftHg
#	@return	ݒl
#
#------------------------------------------------------------------------------------------------------------
sub Get
{
	my $this = shift;
	my ($key, $default) = @_;
	
	my $val = $this->{'NEWRELEASE'}->{$key};
	
	return (defined $val ? $val : (defined $default ? $default : undef));
}

#------------------------------------------------------------------------------------------------------------
#
#	ݒlݒ - Set
#	-------------------------------------------------------------------------------------
#	@param	$key	ݒL[
#	@param	$data	ݒl
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Set
{
	my $this = shift;
	my ($key, $data) = @_;
	
	$this->{'NEWRELEASE'}->{$key} = $data;
}

1;
