#============================================================================================================
#
#	tH[ǗW[(SAMWISE)
#	samwise.pl
#	---------------------------------------------
#	2002.12.13 start
#	2003.02.10 IsInput,IsInputAllǉ
#	2010.08.14 R[hϊp~
#	           ֑ړ
#
#============================================================================================================
package	SAMWISE;

use strict;
#RgAEgOꍇ͕ϐ̏`FbN邱ƁB
##use warnings;

#------------------------------------------------------------------------------------------------------------
#
#	W[RXgN^ - new
#	-------------------------------------------
#	@FȂ
#	߂lFW[IuWFNg
#
#------------------------------------------------------------------------------------------------------------
sub new
{
	my $this = shift;
	my ($throughget) = @_;
	my (%FORM, @SRC, $form, $obj);
	
	if ($ENV{'REQUEST_METHOD'} eq 'POST') {					# POST\bh
		read STDIN, $form, $ENV{'CONTENT_LENGTH'};
	}
	elsif ($throughget && defined $ENV{'QUERY_STRING'}) {	# GET\bh
		$form = $ENV{'QUERY_STRING'};
	}
	else {
		$form = '';
	}
	
	@SRC = split(/&/, $form);								# f[^
	
	$obj = {
		'FORM'	=> \%FORM,
		'SRC'	=> \@SRC
	};
	
	bless $obj, $this;
	
	return $obj;
}

#------------------------------------------------------------------------------------------------------------
#
#	tH[fR[h - DecodeForm
#	-------------------------------------------
#	@F$mode : 
#	߂lFȂ
#
#------------------------------------------------------------------------------------------------------------
sub DecodeForm
{
	my $this = shift;
	my ($mode) = @_;
	my ($var, $val, $code);
	
	undef %{$this->{'FORM'}};
	
	foreach (@{$this->{'SRC'}}) {										# ef[^Ƃɏ
		($var, $val) = split(/=/, $_);									# name/valueŕ
		$val =~ tr/+/ /;
		$val =~ s/%([0-9a-fA-F][0-9a-fA-F])/pack('C', hex($1))/eg;
		$val =~ s/\r\n|\r|\n/\n/g;										# s𓝈
		$val =~ s/\0//g;												# ʂ
		$this->{'FORM'}->{$var} = $val;									# f[^Zbg
		
		$this->{'FORM'}->{"Raw_$var"} = $val;							# f[^Zbg
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	tH[fR[h - GetAtArray
#	-------------------------------------------
#	@F$key : 擾L[
#			$f   : ϊtO
#	߂lFL[f[^̔z
#
#------------------------------------------------------------------------------------------------------------
sub GetAtArray
{
	my $this = shift;
	my ($key, $f) = @_;
	my ($var, $val, $code, @ret);
	
	undef @ret;
	
	foreach (@{$this->{'SRC'}}) {											# ef[^Ƃɏ
		($var, $val) = split(/=/, $_);										# name/valueŕ
		if ($key eq $var) {													# wL[
			$val =~ tr/+/ /;
			$val =~ s/%([0-9a-fA-F][0-9a-fA-F])/pack('C', hex($1))/eg;
			$val =~ s/\r\n|\r|\n/\n/g;										# s𓝈
			$val =~ s/\0//g;												# ʂ
			if ($f) {
				$val =~ s/"/&quot;/g;										# ꕶ΍ "
				$val =~ s/</&lt;/g;											# ꕶ΍ <
				$val =~ s/>/&gt;/g;											# ꕶ΍ >
				$val =~ s/\r\n|\r|\n/<br>/g;								# s
			}
			push @ret, $val;
		}
	}
	return @ret;
}

#------------------------------------------------------------------------------------------------------------
#
#	tH[擾 - Get
#	-------------------------------------------
#	@F$key : 擾L[
#			$default : ftHg
#	߂lFf[^
#
#------------------------------------------------------------------------------------------------------------
sub Get
{
	my $this = shift;
	my ($key, $default) = @_;
	my ($val);
	
	$val = $this->{'FORM'}->{$key};
	
	return (defined $val ? $val : (defined $default ? $default : ''));
}

#------------------------------------------------------------------------------------------------------------
#
#	tH[ݒ - Set
#	-------------------------------------------
#	@F$key  : 擾L[
#			$data : ݒf[^
#	߂lFȂ
#
#------------------------------------------------------------------------------------------------------------
sub Set
{
	my $this = shift;
	my ($key, $data) = @_;
	
	$this->{'FORM'}->{$key} = $data;
}

#------------------------------------------------------------------------------------------------------------
#
#	forml݊mF
#	-------------------------------------------------------------------------------------
#	@param	$key	L[
#	@param	$data	l
#	@return	lȂtrueԂ
#
#------------------------------------------------------------------------------------------------------------
sub Equal
{
	my $this = shift;
	my ($key, $data) = @_;
	my ($val);
	
	$val = $this->{'FORM'}->{$key};
	
	return (defined $val && $val eq $data);
}

#------------------------------------------------------------------------------------------------------------
#
#	̓`FbN - IsInput
#	-------------------------------------------
#	@F@keylist : 荀ڃXg
#	߂lFOKȂ1,͂Ȃ0
#
#------------------------------------------------------------------------------------------------------------
sub IsInput
{
	my $this = shift;
	my ($pKeyList) = @_;
	
	foreach (@$pKeyList) {
		if ($this->{'FORM'}->{$_} eq '') {
			return 0;
		}
	}
	return 1;
}

#------------------------------------------------------------------------------------------------------------
#
#	S̓`FbN - IsInput
#	-------------------------------------------
#	@FȂ
#	߂lFOKȂ1,͂Ȃ0
#
#------------------------------------------------------------------------------------------------------------
sub IsInputAll
{
	my $this = shift;
	
	foreach (keys %{$this->{'FORM'}}) {
		if ($this->{'FORM'}->{$_} eq '') {
			return 0;
		}
	}
	return 1;
}

#------------------------------------------------------------------------------------------------------------
#
#	forml݊mF
#	-------------------------------------------------------------------------------------
#	@param	$key	L[
#	@return	L[݂true
#
#------------------------------------------------------------------------------------------------------------
sub IsExist
{
	my $this = shift;
	my ($key) = @_;
	
	return exists $this->{'FORM'}->{$key};
}

#------------------------------------------------------------------------------------------------------------
#
#	forml݊mF
#	-------------------------------------------------------------------------------------
#	@param	$key	L[
#	@param	$string	
#	@return	݂1
#
#------------------------------------------------------------------------------------------------------------
sub Contain
{
	my $this = shift;
	my ($key, $string) = @_;
	
	if ($this->{'FORM'}->{$key} =~ /\Q$string\E/) {
		return 1;
	}
	return 0;
}

#------------------------------------------------------------------------------------------------------------
#
#	forml擾
#	-------------------------------------------------------------------------------------
#	@param	$pArray	ʊi[obt@
#	@param	@list	擾f[^Xg
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub GetListData
{
	my $this = shift;
	my ($pArray, @list) = @_;
	
	foreach (@list) {
		push @$pArray, $this->{'FORM'}->{$_};
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	
#	-------------------------------------------------------------------------------------
#	@param	$pKeys	f[^L[
#	@return	Ȃ1
#
#------------------------------------------------------------------------------------------------------------
sub IsNumber
{
	my $this = shift;
	my ($pKeys) = @_;
	
	foreach (@$pKeys) {
		if ($this->{'FORM'}->{$_} =~ /\D/) {
			return 0;
		}
	}
	return 1;
}

#------------------------------------------------------------------------------------------------------------
#
#	pp
#	-------------------------------------------------------------------------------------
#	@param	$pKeys	f[^L[
#	@return	ppȂ1
#
#------------------------------------------------------------------------------------------------------------
sub IsAlphabet
{
	my $this = shift;
	my ($pKeys) = @_;
	
	foreach (@$pKeys) {
		if ($this->{'FORM'}->{$_} =~ /[^0-9a-zA-Z_@]/) {
			return 0;
		}
	}
	return 1;
}

#------------------------------------------------------------------------------------------------------------
#
#	LbvL[p񒲍
#	-------------------------------------------------------------------------------------
#	@param	$pKeys	f[^L[
#	@return	ppȂ1
#
#------------------------------------------------------------------------------------------------------------
sub IsCapKey
{
	my $this = shift;
	my ($pKeys) = @_;
	
	foreach (@$pKeys) {
		if ($this->{'FORM'}->{$_} =~ /[^0-9a-zA-Z\_\.\+\-\*\/\@\:\!\%\&\(\)\=\~\^]/) {
			return 0;
		}
	}
	return 1;
}

#------------------------------------------------------------------------------------------------------------
#
#	ffBNgp񒲍
#	-------------------------------------------------------------------------------------
#	@param	$pKeys	f[^L[
#	@return	ppȂ1
#
#------------------------------------------------------------------------------------------------------------
sub IsBBSDir
{
	my $this = shift;
	my ($pKeys) = @_;
	
	foreach (@$pKeys) {
		if ($this->{'FORM'}->{$_} =~ /[^0-9a-zA-Z\_\-]/) {
			return 0;
		}
	}
	return 1;
}

#============================================================================================================
#	W[I[
#============================================================================================================
1;
