#!/usr/bin/perl
#============================================================================================================
#
#	ݗpCGI
#
#============================================================================================================

use lib './perllib';

use strict;
use warnings;
no warnings 'once';
#use CGI::Carp qw(fatalsToBrowser warningsToBrowser);


# CGI̎sʂIR[hƂ
exit(BBSCGI());

#------------------------------------------------------------------------------------------------------------
#
#	bbs.cgiC
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	G[ԍ
#
#------------------------------------------------------------------------------------------------------------
sub BBSCGI
{
	require './module/constant.pl';
	
	require './module/thorin.pl';
	my $Page = THORIN->new;
	
	my $CGI = {};
	my $err = $ZP::E_SUCCESS;
	
	$err = Initialize($CGI, $Page);
	# ɐ珑ݏJn
	if ($err == $ZP::E_SUCCESS) {
		my $Sys = $CGI->{'SYS'};
		my $Form = $CGI->{'FORM'};
		my $Set = $CGI->{'SET'};
		my $Conv = $CGI->{'CONV'};
		my $Threads = $CGI->{'THREADS'};
		
		require './module/vara.pl';
		my $WriteAid = VARA->new;
		$WriteAid->Init($Sys, $Form, $Set, $Threads, $Conv);
		
		$err = $WriteAid->Write();
		# ݂ɐf\vfXV
		if ($err == $ZP::E_SUCCESS) {
			if (!$Sys->Equal('FASTMODE', 1)) {
				require './module/varda.pl';
				my $BBSAid = VARDA->new;
				
				$BBSAid->Init($Sys, $Set);
				$BBSAid->CreateIndex();
				$BBSAid->CreateIIndex();
				$BBSAid->CreateSubback();
			}
			PrintBBSJump($CGI, $Page);
		}
		else {
			PrintBBSError($CGI, $Page, $err);
		}
	}
	else {
		# Xbh쐬ʕ\
		if ($err == $ZP::E_PAGE_THREAD) {
			PrintBBSThreadCreate($CGI, $Page);
			$err = $ZP::E_SUCCESS;
		}
		# cookiemFʕ\
		elsif ($err == $ZP::E_PAGE_COOKIE) {
			PrintBBSCookieConfirm($CGI, $Page);
			$err = $ZP::E_SUCCESS;
		}
		# gт̃Xbh쐬ʕ\
		elsif ($err == $ZP::E_PAGE_THREADMOBILE) {
			PrintBBSMobileThreadCreate($CGI, $Page);
			$err = $ZP::E_SUCCESS;
		}
		# G[ʕ\
		else {
			PrintBBSError($CGI, $Page, $err);
		}
	}
	
	# ʂ̕\
	$Page->Flush('', 0, 0);
	
	return $err;
}

#------------------------------------------------------------------------------------------------------------
#
#	bbs.cgi
#	-------------------------------------------------------------------------------------
#	@param	$CGI
#	@param	$Page
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Initialize
{
	my ($CGI, $Page) = @_;
	
	# gpW[̏
	require './module/melkor.pl';
	require './module/isildur.pl';
	require './module/radagast.pl';
	require './module/galadriel.pl';
	require './module/samwise.pl';
	require './module/baggins.pl';
	
	my $Sys = MELKOR->new;
	my $Conv = GALADRIEL->new;
	my $Set = ISILDUR->new;
	my $Cookie = RADAGAST->new;
	my $Threads = BILBO->new;
	
	# VXeݒ
	return $ZP::E_SYSTEM_ERROR if ($Sys->Init());
	
	my $Form = SAMWISE->new($Sys->Get('BBSGET'));
	
	%$CGI = (
		'SYS'		=> $Sys,
		'SET'		=> $Set,
		'COOKIE'	=> $Cookie,
		'CONV'		=> $Conv,
		'PAGE'		=> $Page,
		'FORM'		=> $Form,
		'THREADS'	=> $Threads,
	);
	
	# L
	$Sys->Set('MainCGI', $CGI);
	
	# formݒ
	$Form->DecodeForm(1);
	
	# zXgݒ(DNSt)
	#ϐ`FbN}B
	if(!defined $ENV{'REMOTE_HOST'} || $ENV{'REMOTE_HOST'} eq '') {
		$ENV{'REMOTE_HOST'} = $Conv->GetRemoteHost();
	}
	$Form->Set('HOST', $ENV{'REMOTE_HOST'});
	
	my $client = $Conv->GetClient();
	
	$Sys->Set('ENCODE', 'Shift_JIS');
	$Sys->Set('BBS', $Form->Get('bbs', ''));
	$Sys->Set('KEY', $Form->Get('key', ''));
	$Sys->Set('CLIENT', $client);
	$Sys->Set('AGENT', $Conv->GetAgentMode($client));
	$Sys->Set('KOYUU', $ENV{'REMOTE_HOST'});
	$Sys->Set('BBSPATH_ABS', $Conv->MakePath($Sys->Get('CGIPATH'), $Sys->Get('BBSPATH')));
	$Sys->Set('BBS_ABS', $Conv->MakePath($Sys->Get('BBSPATH_ABS'), $Sys->Get('BBS')));
	$Sys->Set('BBS_REL', $Conv->MakePath($Sys->Get('BBSPATH'), $Sys->Get('BBS')));
	
	# gт̏ꍇ͋@ݒ
	if ($client & $ZP::C_MOBILE_IDGET) {
		my $product = $Conv->GetProductInfo($client);
		
		if (!defined $product) {
			return $ZP::E_POST_NOPRODUCT;
		}
		
		$Sys->Set('KOYUU', $product);
	}
	
	# SETTING.TXT̓ǂݍ
	if (!$Set->Load($Sys)) {
		return $ZP::E_POST_NOTEXISTBBS;
	}
	
	# gт̃Xbh쐬tH[\
	# $S->Equal('AGENT', 'O') && 
	if ($Form->Equal('mb', 'on') && $Form->Equal('thread', 'on')) {
		return $ZP::E_PAGE_THREADMOBILE;
	}
	
	my $submax = $Set->Get('BBS_SUBJECT_MAX') || $Sys->Get('SUBMAX');
	$Sys->Set('SUBMAX', $submax);
	my $resmax = $Set->Get('BBS_RES_MAX') || $Sys->Get('RESMAX');
	$Sys->Set('RESMAX', $resmax);
	
	# formkey݂烌X
	if ($Form->IsExist('key'))	{ $Sys->Set('MODE', 2); }
	else						{ $Sys->Set('MODE', 1); }
	
	# Xbh쐬[hMESSAGEFXbh쐬
	if ($Sys->Equal('MODE', 1)) {
		if (!$Form->IsExist('MESSAGE')) {
			return $ZP::E_PAGE_THREAD;
		}
		$Form->Set('key', int(time));
		$Sys->Set('KEY', $Form->Get('key'));
	}
	
	# cookiȇ݃`FbN(PĈ)
	if ($client & $ZP::C_PC) {
		if ($Set->Equal('SUBBBS_CGI_ON', 1)) {
			# ϐ擾s
			if (!$Cookie->Init()) {
				return $ZP::E_PAGE_COOKIE;
			}
			
			# Ocookie
			if ($Set->Equal('BBS_NAMECOOKIE_CHECK', 'checked') && !$Cookie->IsExist('NAME')) {
				return $ZP::E_PAGE_COOKIE;
			}
			# [cookie
			if ($Set->Equal('BBS_MAILCOOKIE_CHECK', 'checked') && !$Cookie->IsExist('MAIL')) {
				return $ZP::E_PAGE_COOKIE;
			}
		}
	}
	
	# subject̓ǂݍ
	$Threads->Load($Sys);
	
	return $ZP::E_SUCCESS;
}

#------------------------------------------------------------------------------------------------------------
#
#	bbs.cgiXbh쐬y[W\
#	-------------------------------------------------------------------------------------
#	@param	$CGI
#	@param	$Page
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub PrintBBSThreadCreate
{
	my ($CGI, $Page) = @_;
	
	my $Sys = $CGI->{'SYS'};
	my $Set = $CGI->{'SET'};
	my $Form = $CGI->{'FORM'};
	my $Cookie = $CGI->{'COOKIE'};
	
	require './module/legolas.pl';
	my $Caption = LEGOLAS->new;
	$Caption->Load($Sys, 'META');
	
	my $title = $Set->Get('BBS_TITLE');
	my $link = $Set->Get('BBS_TITLE_LINK');
	my $image = $Set->Get('BBS_TITLE_PICTURE');
	my $code = $Sys->Get('ENCODE');
	my $cgipath = $Sys->Get('CGIPATH');
	
	# HTMLwb_̏o
	$Page->Print("Content-type: text/html\n\n");
	$Page->Print("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n");
	$Page->Print("<html lang=\"ja\">\n");
	$Page->Print("<head>\n");
	$Page->Print(' <meta http-equiv="Content-Type" content="text/html;charset=Shift_JIS">'."\n\n");
	$Caption->Print($Page, undef);
	$Page->Print(" <title>$title</title>\n\n");
	$Page->Print("</head>\n<!--nobanner-->\n");
	
	# <body>^Oo
	{
		my @work;
		$work[0] = $Set->Get('BBS_BG_COLOR');
		$work[1] = $Set->Get('BBS_TEXT_COLOR');
		$work[2] = $Set->Get('BBS_LINK_COLOR');
		$work[3] = $Set->Get('BBS_ALINK_COLOR');
		$work[4] = $Set->Get('BBS_VLINK_COLOR');
		$work[5] = $Set->Get('BBS_BG_PICTURE');
		
		$Page->Print("<body bgcolor=\"$work[0]\" text=\"$work[1]\" link=\"$work[2]\" ");
		$Page->Print("alink=\"$work[3]\" vlink=\"$work[4]\" ");
		$Page->Print("background=\"$work[5]\">\n");
	}

	$Page->Print("<div align=\"center\">");
	# Ŕ摜\
	if ($image ne '') {
		# Ŕ摜̃N
		if ($link ne '') {
			$Page->Print("<a href=\"$link\"><img src=\"$image\" border=\"0\" alt=\"$image\"></a><br>");
		}
		# Ŕ摜ɃN͂Ȃ
		else {
			$Page->Print("<img src=\"$image\" border=\"0\"><br>");
		}
	}
	$Page->Print("</div>");

	# wb_e[u̕\
	$Caption->Load($Sys, 'HEAD');
	$Caption->Print($Page, $Set);
	
	# Xbh쐬tH[̕\
	{
		my $tblCol = $Set->Get('BBS_MAKETHREAD_COLOR');
		my $name = $Cookie->Get('NAME', '', 'utf8');
		my $mail = $Cookie->Get('MAIL', '', 'utf8');
		my $bbs = $Form->Get('bbs');
		my $tm = int(time);
		my $ver = $Sys->Get('VERSION');
		
		$Page->Print(<<HTML);
<table border="1" cellspacing="7" cellpadding="3" width="95%" bgcolor="$tblCol" align="center">
 <tr>
  <td>
  <b>XbhVK쐬</b><br>
  <center>
  <form method="POST" action="./bbs.cgi?guid=ON">
  <input type="hidden" name="bbs" value="$bbs"><input type="hidden" name="time" value="$tm">
  <table border="0">
   <tr>
    <td align="left">
    ^CgF<input type="text" name="subject" size="25">@<input type="submit" value="VKXbh쐬"><br>
    OF<input type="text" name="FROM" size="19" value="$name">
    E-mail<font size="1">iȗj</font>F<input type="text" name="mail" size="19" value="$mail"><br>
    <textarea rows="5" cols="64" name="MESSAGE"></textarea>
    </td>
   </tr>
  </table>
  </form>
  </center>
  </td>
 </tr>
</table>

<p>
$ver
</p>
HTML
	}

	$Page->Print("\n</body>\n</html>\n");
}

#------------------------------------------------------------------------------------------------------------
#
#	bbs.cgiXbh쐬y[W(g)\
#	-------------------------------------------------------------------------------------
#	@param	$CGI	
#	@param	$Page	THORIN
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub PrintBBSMobileThreadCreate
{
	my ($CGI, $Page) = @_;
	
	my $Sys = $CGI->{'SYS'};
	my $Set = $CGI->{'SET'};
	
	require './module/denethor.pl';
	my $Banner = DENETHOR->new;
	$Banner->Load($Sys);
	
	my $title = $Set->Get('BBS_TITLE');
	my $bbs = $Sys->Get('BBS');
	my $tm = int(time);
	
	$Page->Print("Content-type: text/html\n\n");
	$Page->Print("<html><head><title>$title</title></head><!--nobanner-->");
	$Page->Print("\n<body><form action=\"./bbs.cgi?guid=ON\" method=\"POST\"><center>$title<hr>");
	
	$Banner->Print($Page, 100, 2, 1);
	
	$Page->Print("</center>\n");
	$Page->Print("^Cg<br><input type=text name=subject><br>");
	$Page->Print("O<br><input type=text name=FROM><br>");
	$Page->Print("[<br><input type=text name=mail><br>");
	$Page->Print("<textarea name=MESSAGE></textarea><br>");
	$Page->Print("<input type=hidden name=bbs value=$bbs>");
	$Page->Print("<input type=hidden name=time value=$tm>");
	$Page->Print("<input type=hidden name=mb value=on>");
	$Page->Print("<input type=submit value=\"Xbh쐬\">");
	$Page->Print("</form></body></html>");
}

#------------------------------------------------------------------------------------------------------------
#
#	bbs.cgiNbL[mFy[W\
#	-------------------------------------------------------------------------------------
#	@param	$CGI	
#	@param	$Page	THORIN
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub PrintBBSCookieConfirm
{
	my ($CGI, $Page) = @_;
	
	my $Sys = $CGI->{'SYS'};
	my $Form = $CGI->{'FORM'};
	my $Set = $CGI->{'SET'};
	my $Cookie = $CGI->{'COOKIE'};
	
	my $sanitize = sub {
		$_ = shift;
		s/&/&amp;/g;
		s/</&lt;/g;
		s/>/&gt;/g;
		s/"/&#34;/g;
		return $_;
	};
	my $code = $Sys->Get('ENCODE');
	my $bbs = &$sanitize($Form->Get('bbs'));
	my $tm = int(time);
	my $name = &$sanitize($Form->Get('FROM'));
	my $mail = &$sanitize($Form->Get('mail'));
	my $msg = &$sanitize($Form->Get('MESSAGE'));
	my $subject = &$sanitize($Form->Get('subject'));
	my $key = &$sanitize($Form->Get('key'));
	
	# cookiȅo
	$Cookie->Set('NAME', $name, 'utf8')	if ($Set->Equal('BBS_NAMECOOKIE_CHECK', 'checked'));
	$Cookie->Set('MAIL', $mail, 'utf8')	if ($Set->Equal('BBS_MAILCOOKIE_CHECK', 'checked'));
	$Cookie->Out($Page, $Set->Get('BBS_COOKIEPATH'), 60 * 24 * 30);
	
	$Page->Print("Content-type: text/html\n\n");
	$Page->Print(<<HTML);
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<!-- 2ch_X:cookie -->
<head>

 <meta http-equiv="Content-Type" content="text/html; charset=Shift_JIS">

 <title> ݊mF </title>

</head>
<!--nobanner-->
HTML
	
	# <body>^Oo
	{
		my @work;
		$work[0] = $Set->Get('BBS_THREAD_COLOR');
		$work[1] = $Set->Get('BBS_TEXT_COLOR');
		$work[2] = $Set->Get('BBS_LINK_COLOR');
		$work[3] = $Set->Get('BBS_ALINK_COLOR');
		$work[4] = $Set->Get('BBS_VLINK_COLOR');
		
		$Page->Print("<body bgcolor=\"$work[0]\" text=\"$work[1]\" link=\"$work[2]\" ");
		$Page->Print("alink=\"$work[3]\" vlink=\"$work[4]\">\n");
	}
	
	$Page->Print(<<HTML);
<font size="4" color="#FF0000"><b>݁NbL[mF</b></font>
<blockquote style="margin-top:4em;">
 OF $name<br>
 E-mailF $mail<br>
 eF<br>
 $msg<br>
</blockquote>

<div style="font-weight:bold;">
emF<br>
Ee҂́AeɊւĔӔCSēe҂ɋAƂ܂B<br>
Ee҂́AbƖ֌WȍL̓eɊւāA̔pxƂ܂<br>
Ee҂́AeꂽeɂāAf^c҂Rs[AۑApA]ړ̗p邱Ƃ܂B<br>
@܂Af^c҂ɑ΂āAҐli؍sgȂƂ܂B<br>
Ee҂́Af^c҂w肷O҂ɑ΂āA앨̗p؂ȂƂ܂B<br>
</div>

<form method="POST" action="./bbs.cgi?guid=ON">
HTML
	
	$msg =~ s/<br>/\n/g;
	
	$Page->HTMLInput('hidden', 'subject', $subject);
	$Page->HTMLInput('hidden', 'FROM', $name);
	$Page->HTMLInput('hidden', 'mail', $mail);
	$Page->HTMLInput('hidden', 'MESSAGE', $msg);
	$Page->HTMLInput('hidden', 'bbs', $bbs);
	$Page->HTMLInput('hidden', 'time', $tm);
	
	# X݃[h̏ꍇkeyݒ肷
	if ($Sys->Equal('MODE', 2)) {
		$Page->HTMLInput('hidden', 'key', $key);
	}
	
	$Page->Print(<<HTML);
<input type="submit" value="LSĂď"><br>
</form>

<p>
ύXꍇ͖߂{^Ŗ߂ďĉB
</p>

<p>
݁Ar炵΍ŃNbL[ݒ肵ĂȂƏ݂łȂ悤ɂĂ܂B<br>
<font size="2">(cookieݒ肷Ƃ̉ʂ͂łȂȂ܂B)</font><br>
</p>

</body>
</html>
HTML
}


#------------------------------------------------------------------------------------------------------------
#
#	bbs.cgiWvy[W\
#	-------------------------------------------------------------------------------------
#	@param	$CGI
#	@param	$Page
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub PrintBBSJump
{
	my ($CGI, $Page) = @_;
	
	my $Sys = $CGI->{'SYS'};
	my $Form = $CGI->{'FORM'};
	my $Set = $CGI->{'SET'};
	my $Conv = $CGI->{'CONV'};
	my $Cookie = $CGI->{'COOKIE'};
	
	# gїp\
	if ($Form->Equal('mb', 'on') || ($Sys->Get('CLIENT') & $ZP::C_MOBILEBROWSER) ) {
		my $bbsPath = $Conv->MakePath($Sys->Get('CGIPATH').'/r.cgi/'.$Form->Get('bbs').'/'.$Form->Get('key').'/l10');
		$Page->Print("Content-type: text/html\n\n");
		$Page->Print('<!--nobanner--><html><body>݊ł<br>');
		$Page->Print("<a href=\"$bbsPath\"></a>");
		$Page->Print("f֖߂ĂB\n");
	}
	# PCp\
	else {
		my $bbsPath = $Conv->MakePath($Sys->Get('BBS_REL'));
		my $name = $Form->Get('NAME', '');
		my $mail = $Form->Get('MAIL', '');
		
		$Cookie->Set('NAME', $name, 'utf8')	if ($Set->Equal('BBS_NAMECOOKIE_CHECK', 'checked'));
		$Cookie->Set('MAIL', $mail, 'utf8')	if ($Set->Equal('BBS_MAILCOOKIE_CHECK', 'checked'));
		$Cookie->Out($Page, $Set->Get('BBS_COOKIEPATH'), 60 * 24 * 30);
		
		$Page->Print("Content-type: text/html\n\n");
		$Page->Print(<<HTML);
<html>
<head>
	<title>݂܂B</title>
<meta http-equiv="Content-Type" content="text/html; charset=Shift_JIS">
<meta http-equiv="Refresh" content="5;URL=$bbsPath/">
</head>
<!--nobanner-->
<body>
݂I܂B<br>
<br>
ʂ؂ւ܂ł΂炭҂B<br>
<br>
<br>
<br>
<br>
<hr>
HTML
	
	}
	# m\(\Ȃꍇ̓RgAEg0)
	if (0) {
		require './module/denethor.pl';
		my $Banner = DENETHOR->new;
		$Banner->Load($Sys);
		$Banner->Print($Page, 100, 0, $Sys->Get('AGENT'));
	}
	$Page->Print("\n</body>\n</html>\n");
}

#------------------------------------------------------------------------------------------------------------
#
#	bbs.cgiG[y[W\
#	-------------------------------------------------------------------------------------
#	@param	$CGI
#	@param	$Page
#	@param	$err
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub PrintBBSError
{
	my ($CGI, $Page, $err) = @_;
	
	require './module/orald.pl';
	my $Error = ORALD->new;
	$Error->Load($CGI->{'SYS'});
	
	$Error->Print($CGI, $Page, $err, $CGI->{'SYS'}->Get('AGENT'));
}

