#============================================================================================================
#
#	cookieǗW[
#
#============================================================================================================
package RADAGAST;

use strict;
use warnings;
use Encode;

#------------------------------------------------------------------------------------------------------------
#
#	RXgN^
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	W[IuWFNg
#
#------------------------------------------------------------------------------------------------------------
sub new
{
	my $class = shift;
	
	my $obj = {
		'COOKIE'	=> undef,
	};
	bless $obj, $class;
	
	return $obj;
}

#------------------------------------------------------------------------------------------------------------
#
#	cookiel擾
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Init
{
	my $this = shift;
	
	$this->{'COOKIE'} = {};
	
	if ($ENV{'HTTP_COOKIE'}) {
		my @pairs = split(/;\s*/, $ENV{'HTTP_COOKIE'});
		foreach (@pairs) {
			my ($name, $value) = split(/=/, $_, 2);
			$value =~ s/^"|"$//g;
			$value =~ s/%([0-9A-Fa-f][0-9A-Fa-f])/pack('H2', $1)/eg;
			$this->{'COOKIE'}->{$name} = $value;
		}
		return 1;
	}
	return 0;
}
#------------------------------------------------------------------------------------------------------------
#
#	cookielݒ
#	-------------------------------------------------------------------------------------
#	@param	$key	L[
#	@param	$val	ݒl
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Set
{
	my $this = shift;
	my ($key, $val, $enc) = @_;
	
	Encode::from_to($val, 'sjis', $enc) if (defined $enc);
	$this->{'COOKIE'}->{$key} = $val;
}

#------------------------------------------------------------------------------------------------------------
#
#	cookiel擾
#	-------------------------------------------------------------------------------------
#	@param	$key	L[
#			$default : ftHg
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Get
{
	my $this = shift;
	my ($key, $default, $enc) = @_;
	
	my $val = $this->{'COOKIE'}->{$key};
	Encode::from_to($val, $enc, 'sjis') if (defined $val && defined $enc);
	
	return (defined $val ? $val : (defined $default ? $default : undef));
}

#------------------------------------------------------------------------------------------------------------
#
#	cookiel폜
#	-------------------------------------------------------------------------------------
#	@param	$key	L[
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Delete
{
	my $this = shift;
	my ($key) = @_;
	
	delete $this->{'COOKIE'}->{$key};
}

#------------------------------------------------------------------------------------------------------------
#
#	cookiel݊mF
#	-------------------------------------------------------------------------------------
#	@param	$key	L[
#	@return	L[݂true
#
#------------------------------------------------------------------------------------------------------------
sub IsExist
{
	my $this = shift;
	my ($key) = @_;
	
	return exists($this->{'COOKIE'}->{$key});
}

#------------------------------------------------------------------------------------------------------------
#
#	cookieo
#	-------------------------------------------------------------------------------------
#	@param	$Page	o̓W[
#	@param	$path	cookiepX
#	@param	$limit	L
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Out
{
	my $this = shift;
	my ($Page, $path, $limit) = @_;
	
	# t̐ݒ
	my @gmt = gmtime(time + $limit * 60);
	my @week = qw(Sun Mon Tue Wed Thu Fri Sat);
	my @month = qw(Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec);
	
	# L񐶐
	my $date = sprintf('%s, %02d-%s-%04d %02d:%02d:%02d GMT',
					$week[$gmt[6]], $gmt[3], $month[$gmt[4]], $gmt[5] + 1900,
					$gmt[2], $gmt[1], $gmt[0]);
	
	# ݒ肳ĂcookieSďo͂
	foreach my $key (keys %{$this->{'COOKIE'}}) {
		my $value = $this->{'COOKIE'}->{$key};
		$value =~ s/([^\w])/'%'.unpack('H2', $1)/eg;
		$Page->Print("Set-Cookie: $key=\"$value\"; expires=$date; path=$path\n");
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	cookie擾pjavascripto
#	-------------------------------------------------------------------------------------
#	@param	$Page	o̓W[
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Print
{
	my $this = shift;
	my ($Page) = @_;
	
	$Page->Print(<<JavaScript);
<script language="JavaScript" type="text/javascript">
<!--
function l(e) {
	var N = getCookie("NAME"), M = getCookie("MAIL");
	for (var i = 0, j = document.forms ; i < j.length ; i++){
		if (j[i].FROM && j[i].mail) {
			j[i].FROM.value = N;
			j[i].mail.value = M;
		}}
}
window.onload = l;
function getCookie(key) {
	var ptrn = '(?:^|;| )' + key + '="(.*?)"';
	if (document.cookie.match(ptrn))
		return decodeURIComponent(RegExp.\$1);
	return "";
}
//-->
</script>
JavaScript
}

#============================================================================================================
#	W[I[
#============================================================================================================
1;
