#============================================================================================================
#
#	[UʒmǗW[
#	gandalf.pl
#	-------------------------------------------------------------------------------------
#	2004.09.11 start
#
#============================================================================================================
package	GANDALF;

use strict;
use warnings;

#------------------------------------------------------------------------------------------------------------
#
#	RXgN^
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	W[IuWFNg
#
#------------------------------------------------------------------------------------------------------------
sub new
{
	my $this = shift;
	my ($obj);
	
	$obj = {
		'TO'		=> undef,
		'FROM'		=> undef,
		'SUBJECT'	=> undef,
		'TEXT'		=> undef,
		'DATE'		=> undef,
		'LIMIT'		=> undef
	};
	bless($obj,$this);
	
	return $obj;
}

#------------------------------------------------------------------------------------------------------------
#
#	ʒmǂݍ
#	-------------------------------------------------------------------------------------
#	@param	$Sys	MELKOR
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Load
{
	my $this = shift;
	my ($Sys) = @_;
	my ($path, @elem);
	
	# nbV
	undef $this->{'TO'};
	undef $this->{'FROM'};
	undef $this->{'SUBJECT'};
	undef $this->{'TEXT'};
	undef $this->{'DATE'};
	
	$path = '.' . $Sys->Get('INFO') . '/notice.cgi';
	
	if (-e $path) {
		open NOTICE, "< $path";
		while (<NOTICE>) {
			chomp $_;
			@elem = split(/<>/, $_);
			$this->{'TO'}->{$elem[0]}		= $elem[1];
			$this->{'FROM'}->{$elem[0]}		= $elem[2];
			$this->{'SUBJECT'}->{$elem[0]}	= $elem[3];
			$this->{'TEXT'}->{$elem[0]}		= $elem[4];
			$this->{'DATE'}->{$elem[0]}		= $elem[5];
			$this->{'LIMIT'}->{$elem[0]}	= $elem[6];
		}
		close NOTICE;
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	ʒmۑ
#	-------------------------------------------------------------------------------------
#	@param	$Sys	MELKOR
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Save
{
	my $this = shift;
	my ($Sys) = @_;
	my ($path, $data);
	
	$path = '.' . $Sys->Get('INFO') . '/notice.cgi';
	
#	eval
	{
		open NOTICE, "> $path";
		flock NOTICE, 2;
		binmode NOTICE;
		#truncate NOTICE, 0;
		#seek NOTICE, 0, 0;
		foreach (keys %{$this->{'TO'}}) {
			$data = join('<>',
				$_,
				$this->{TO}->{$_},
				$this->{FROM}->{$_},
				$this->{SUBJECT}->{$_},
				$this->{TEXT}->{$_},
				$this->{DATE}->{$_},
				$this->{LIMIT}->{$_}
			);
			
			print NOTICE "$data\n";
		}
		close NOTICE;
		chmod $Sys->Get('PM-ADM'), $path;
	};
}

#------------------------------------------------------------------------------------------------------------
#
#	IDZbg擾
#	-------------------------------------------------------------------------------------
#	@param	$kind	
#	@param	$name	[h
#	@param	$pBuf	IDZbgi[obt@
#	@return	L[Zbg
#
#------------------------------------------------------------------------------------------------------------
sub GetKeySet
{
	my $this = shift;
	my ($kind, $name, $pBuf) = @_;
	my ($key, $n);
	
	$n = 0;
	
	if ($kind eq 'ALL') {
		foreach $key (keys(%{$this->{TO}})) {
			push @$pBuf, $key;
			$n++;
		}
	}
	else {
		foreach $key (keys(%{$this->{$kind}})) {
			if (($this->{$kind}->{$key} eq $name) || ($kind eq 'ALL')) {
				push @$pBuf, $key;
				$n++;
			}
		}
	}
	
	return $n;
}

#------------------------------------------------------------------------------------------------------------
#
#	ʒm擾
#	-------------------------------------------------------------------------------------
#	@param	$kind	
#	@param	$key	ID
#			$default : ftHg
#	@return	
#
#------------------------------------------------------------------------------------------------------------
sub Get
{
	my $this = shift;
	my ($kind, $key, $default) = @_;
	my ($val);
	
	$val = $this->{$kind}->{$key};
	
	return (defined $val ? $val : (defined $default ? $default : undef));
}

#------------------------------------------------------------------------------------------------------------
#
#	ʒmǉ
#	-------------------------------------------------------------------------------------
#	@param	$to		ʒm惆[U
#	@param	$from	M[U
#	@param	$subj	^Cg
#	@param	$text	e
#	@return	ID
#
#------------------------------------------------------------------------------------------------------------
sub Add
{
	my $this = shift;
	my ($to, $from, $subj, $text, $limit) = @_;
	my ($id);
	
	$id = time;
	while (exists $this->{'TO'}->{$id}) {
		$id++;
	}
	$this->{'TO'}->{$id}		= $to;
	$this->{'FROM'}->{$id}		= $from;
	$this->{'SUBJECT'}->{$id}	= $subj;
	$this->{'TEXT'}->{$id}		= $text;
	$this->{'DATE'}->{$id}		= time;
	$this->{'LIMIT'}->{$id}		= $limit;
	
	return $id;
}

#------------------------------------------------------------------------------------------------------------
#
#	ʒmݒ
#	-------------------------------------------------------------------------------------
#	@param	$id		ID
#	@param	$kind	
#	@param	$val	ݒl
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Set
{
	my $this = shift;
	my ($id, $kind, $val) = @_;
	
	if (exists $this->{$kind}->{$id}) {
		$this->{$kind}->{$id} = $val;
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	ʒm폜
#	-------------------------------------------------------------------------------------
#	@param	$id		폜ID
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Delete
{
	my $this = shift;
	my ($id) = @_;
	
	delete $this->{'TO'}->{$id};
	delete $this->{'FROM'}->{$id};
	delete $this->{'SUBJECT'}->{$id};
	delete $this->{'TEXT'}->{$id};
	delete $this->{'DATE'}->{$id};
	delete $this->{'LIMIT'}->{$id};
}

#------------------------------------------------------------------------------------------------------------
#
#	ʒm񔻒
#	-------------------------------------------------------------------------------------
#	@param	$id		ʒmID
#	@param	$user	[UID
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub IsInclude
{
	my $this = shift;
	my ($id, $user) = @_;
	my (@users);
	
	# S̒ʒm
	if ($this->{'TO'}->{$id} eq '*') {
		return 1;
	}
	
	@users = split(/\, ?/, $this->{'TO'}->{$id});
	foreach (@users) {
		return 1 if ($_ eq $user);
	}
	return 0;
}

#------------------------------------------------------------------------------------------------------------
#
#	ʒm؂ꔻ
#	-------------------------------------------------------------------------------------
#	@param	$id		ʒmID
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub IsLimitOut
{
	my $this = shift;
	my ($id) = @_;
	my (@users, $now);
	
	# S̒ʒm̏ꍇ̂
	if ($this->{'TO'}->{$id} eq '*') {
		$now = time;
		if ($now > $this->{'LIMIT'}->{$id}) {
			return 1;
		}
	}
	return 0;
}

#------------------------------------------------------------------------------------------------------------
#
#	ʒm惆[U폜
#	-------------------------------------------------------------------------------------
#	@param	$id		ʒmID
#	@param	$user	[UID
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub RemoveToUser
{
	my $this = shift;
	my ($id, $user) = @_;
	my (@users, @news);
	
	# S̒ʒm͌ʍ폜s
	if ($this->{'TO'}->{$id} eq '*') {
		return;
	}
	
	undef @news;
	@users = split(/\, ?/, $this->{'TO'}->{$id});
	
	foreach (@users) {
		if ($_ ne $user) {
			push(@news, $_);
		}
	}
	
	# ׂĂ̒ʒm惆[U폜ꂽA̒ʒm͔j
	if (@news == 0) {
		$this->Delete($id);
	}
	else {
		$this->{'TO'}->{$id} = join(',', @news);
	}
}

sub DEBUG
{
	my $this = shift;
	my ($Page) = @_;
	my ($id);
	
	$Page->Print("<b>DEBUG START</b><br>\n");
	foreach $id (keys %{$this->{'TO'}}) {
		$Page->Print("@ To:" . $this->{'TO'}->{$id} . "<br>\n");
		$Page->Print("@ From:" . $this->{'FROM'}->{$id} . "<br>\n");
		$Page->Print("@ Subject:" . $this->{'SUBJECT'}->{$id} . "<br>\n");
		$Page->Print("@ Text:" . $this->{'TEXT'}->{$id} . "<br>\n");
		$Page->Print("@ Date:" . $this->{'DATE'}->{$id} . "<br>\n");
	}
	$Page->Print("<b>DEBUG END</b><br>\n");
}

#============================================================================================================
#	Module END
#============================================================================================================
1;
