#============================================================================================================
#
#	ZbVǗW[
#
#============================================================================================================

#============================================================================================================
#
#	ZbV}l[WpbP[W
#
#============================================================================================================
package SessionManager;

use strict;
use warnings;

#------------------------------------------------------------------------------------------------------------
#
#	ZbV̎擾
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	SessionIuWFNg
#
#------------------------------------------------------------------------------------------------------------
sub getSession
{
	
	my $session = new Session;
	my $id = createSessionID();
	my $filePath = "./info/session/$id";
	my $check = 1;
	
	# ZbVt@C݂ꍇ͂ǂݍ
	if (open(my $fh, '<', $filePath)) {
		flock($fh, 2);
		my @lines = <$fh>;
		close($fh);
		map { s/[\r\n]+\z// } @lines;
		
		foreach (@lines) {
			# 1s(ZbVJn)擾
			if ($check) {
				$check = 0;
				$session->setId($_);
				if (time - $_ > 3600) {
					$session->setId(time);
					last;
				}
			# 2sڈȍ~(ZbVl)擾
			}
			else {
				my ($key, $value) = split(/=/, $_);
				$value =~ s/&equal;/=/g;
				$session->setAttribute($key, $value);
			}
		}
	# ZbVt@C݂Ȃꍇ͋t@C쐬
	}
	else {
		if (!-e './info/session' || !-d './info/session') {
			require './module/earendil.pl';
			EARENDIL::CreateDirectory('./info/session', 0770);
		}
		open(my $fh, '>', $filePath);
		close($fh);
		$session->setId(time);
	}
	return $session;
}

#------------------------------------------------------------------------------------------------------------
#
#	ZbV̕ۑ
#	-------------------------------------------------------------------------------------
#	@param	$session	SessionIuWFNg
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub setSession
{
	
	my ($session) = @_;
	
	my $id = createSessionID($ENV{'REMOTE_ADDR'});
	my $filePath = "./info/session/$id";
	
	if (open(my $fh, '+<', $filePath)) {
		flock($fh, 2);
		seek($fh, 0, 0);
		binmode($fh);
		
		print $fh $session->getId() . "\n";
		foreach my $key (keys %{$session->{'ATTRIBUTE'}}) {
			my $value = $session->getAttribute($key);
			$value =~ s/=/&equal;/g;
			print $fh "$key=$value\n";
		}
		
		truncate($fh, tell($fh));
		close($fh);
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	ZbV̍폜
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub removeSession
{
	
	my $id = createSessionID($ENV{'REMOTE_ADDR'});
	my $filePath = "./info/session/$id";
	
	unlink $filePath;
}

#------------------------------------------------------------------------------------------------------------
#
#	ZbVID̐
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	ZbVID
#
#------------------------------------------------------------------------------------------------------------
sub createSessionID
{
	
	my $key = $ENV{'REMOTE_ADDR'};
	$key =~ s/\.//g;
	$key = substr($ENV{'REMOTE_ADDR'}, -8);
	
	return substr(crypt($key, substr(crypt($key, 'ZC'), -2)), -26);
}

#============================================================================================================
#
#	ZbVIuWFNgpbP[W
#
#============================================================================================================
package Session;

use strict;
use warnings;

#------------------------------------------------------------------------------------------------------------
#
#	RXgN^
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	ZbVIuWFNg
#
#------------------------------------------------------------------------------------------------------------
sub new
{
	my $class = shift;
	
	my $obj = {
		'ID'		=> undef,
		'ATTRIBUTE'	=> undef,
	};
	bless $obj, $class;
	
	return $obj;
}

#------------------------------------------------------------------------------------------------------------
#
#	fXgN^
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub DESTROY
{
	my $this = shift;
	
	if (defined $this->{'ID'}) {
		SessionManager::setSession($this);
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	ݒ
#	-------------------------------------------------------------------------------------
#	@param	$key	L[
#	@param	$value	l
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub setAttribute
{
	my $this = shift;
	my ($key, $value) = @_;
	
	$this->{'ATTRIBUTE'}->{$key} = $value;
}

#------------------------------------------------------------------------------------------------------------
#
#	擾
#	-------------------------------------------------------------------------------------
#	@param	$key	L[
#	@return	l
#
#------------------------------------------------------------------------------------------------------------
sub getAttribute
{
	my $this = shift;
	my ($key) = @_;
	
	return $this->{'ATTRIBUTE'}->{$key};
}

#------------------------------------------------------------------------------------------------------------
#
#	폜
#	-------------------------------------------------------------------------------------
#	@param	$key	L[
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub removeAttribute
{
	my $this = shift;
	my ($key) = @_;
	
	delete $this->{'ATTRIBUTE'}->{$key};
}

#------------------------------------------------------------------------------------------------------------
#
#	IDݒ
#	-------------------------------------------------------------------------------------
#	@param	$id	ID
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub setId
{
	my $this = shift;
	my ($id) = @_;
	$this->{'ID'} = $id;
}

#------------------------------------------------------------------------------------------------------------
#
#	ID擾
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	ID
#
#------------------------------------------------------------------------------------------------------------
sub getId
{
	my $this = shift;
	return $this->{'ID'};
}

#============================================================================================================
#	Module END
#============================================================================================================
1;
