#============================================================================================================
#
#	VXeǗ - ҏW W[
#
#============================================================================================================
package	MODULE;

use strict;
use warnings;

#------------------------------------------------------------------------------------------------------------
#
#	RXgN^
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	W[IuWFNg
#
#------------------------------------------------------------------------------------------------------------
sub new
{
	my $class = shift;
	
	my $obj = {
		'LOG'	=> [],
	};
	bless $obj, $class;
	
	return $obj;
}

#------------------------------------------------------------------------------------------------------------
#
#	\\bh
#	-------------------------------------------------------------------------------------
#	@param	$Sys	MELKOR
#	@param	$Form	SAMWISE
#	@param	$CGI	ǗVXe
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub DoPrint
{
	my $this = shift;
	my ($Sys, $Form, $CGI) = @_;
	
	# Ǘ}X^IuWFNg̐
	require './mordor/sauron.pl';
	my $Base = SAURON->new;
	$Base->Create($Sys, $Form);
	
	my $subMode = $Form->Get('MODE_SUB');
	
	# j[̐ݒ
	SetMenuList($Base, $CGI);
	
	my $indata = undef;
	
	# PCpmҏW
	if ($subMode eq 'BANNER_PC') {
		$indata = PreparePageBannerForPCEdit($Sys, $Form);
	}
	# gїpmҏW
	elsif ($subMode eq 'BANNER_MOBILE') {
		$indata = PreparePageBannerForMobileEdit($Sys, $Form);
	}
	# TumҏW
	elsif ($subMode eq 'BANNER_SUB') {
		$indata = PreparePageBannerForSubEdit($Sys, $Form);
	}
	# VXeݒ芮
	elsif ($subMode eq 'COMPLETE') {
		$indata = $Base->PreparePageComplete('VXeҏW', $this->{'LOG'});
	}
	# VXeݒ莸s
	elsif ($subMode eq 'FALSE') {
		$indata = $Base->PreparePageError($this->{'LOG'});
	}
	
	$Base->Print($Sys->Get('_TITLE'), 1, $indata);
}

#------------------------------------------------------------------------------------------------------------
#
#	@\\bh
#	-------------------------------------------------------------------------------------
#	@param	$Sys	MELKOR
#	@param	$Form	SAMWISE
#	@param	$CGI	ǗVXe
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub DoFunction
{
	my $this = shift;
	my ($Sys, $Form, $CGI) = @_;
	
	my $subMode = $Form->Get('MODE_SUB');
	my $err = 0;
	
	# PCpm
	if ($subMode eq 'BANNER_PC') {
		$err = FunctionBannerEdit($Sys, $Form, 1, $this->{'LOG'});
	}
	# gїpm
	elsif ($subMode eq 'BANNER_MOBILE') {
		$err = FunctionBannerEdit($Sys, $Form, 2, $this->{'LOG'});
	}
	# Tuoi[
	elsif ($subMode eq 'BANNER_SUB') {
		$err = FunctionBannerEdit($Sys, $Form, 3, $this->{'LOG'});
	}
	
	# ʕ\
	if ($err) {
		$CGI->{'LOGGER'}->Put($Form->Get('UserName'), "SYSTEM_EDIT($subMode)", "ERROR:$err");
		push @{$this->{'LOG'}}, $err;
		$Form->Set('MODE_SUB', 'FALSE');
	}
	else {
		$CGI->{'LOGGER'}->Put($Form->Get('UserName'), "SYSTEM_EDIT($subMode)", 'COMPLETE');
		$Form->Set('MODE_SUB', 'COMPLETE');
	}
	
	$this->DoPrint($Sys, $Form, $CGI);
}

#------------------------------------------------------------------------------------------------------------
#
#	j[Xgݒ
#	-------------------------------------------------------------------------------------
#	@param	$Base	SAURON
#	@param	$CGI	
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub SetMenuList
{
	my ($Base, $CGI) = @_;
	
	$Base->SetMenu('mҏW(PCp)', "'sys.edit','DISP','BANNER_PC'");
	$Base->SetMenu('mҏW(gїp)', "'sys.edit','DISP','BANNER_MOBILE'");
	$Base->SetMenu('mҏW(Tu)', "'sys.edit','DISP','BANNER_SUB'");
}

#------------------------------------------------------------------------------------------------------------
#
#	m(PC)ҏWʂ̕\
#	-------------------------------------------------------------------------------------
#	@param	$Sys	VXeϐ
#	@param	$Form	tH[ϐ
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub PreparePageBannerForPCEdit
{
	my ($Sys, $Form) = @_;
	
	require './module/denethor.pl';
	my $Banner = DENETHOR->new;
	$Banner->Load($Sys);
	
	my $bgColor;
	my $content;
	
	# mvr[\
	if ($Form->IsExist('PC_CONTENT')) {
		$Banner->Set('COLPC', $Form->Get('PC_BGCOLOR'));
		$Banner->Set('TEXTPC', $Form->Get('PC_CONTENT'));
		$bgColor = $Form->Get('PC_BGCOLOR');
		$content = $Form->Get('PC_CONTENT');
	}
	else {
		$bgColor = $Banner->Get('COLPC');
		$content = $Banner->Get('TEXTPC');
	}
	
	# vr[f[^̍쐬
	my $bdata = $Banner->Prepare(100, 0, 0);
	
	my $indata = {
		'title'		=> 'PC Banner Edit',
		'intmpl'	=> 'sys.edit.bannerpc',
		'banner'	=> $bdata,
		'bgcolor'	=> $bgColor,
		'content'	=> $content,
	};
	
	return $indata;
}

#------------------------------------------------------------------------------------------------------------
#
#	m(g)ҏWʂ̕\
#	-------------------------------------------------------------------------------------
#	@param	$Sys	VXeϐ
#	@param	$Form	tH[ϐ
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub PreparePageBannerForMobileEdit
{
	my ($Sys, $Form) = @_;
	
	require './module/denethor.pl';
	my $Banner = DENETHOR->new;
	$Banner->Load($Sys);
	
	my $bgColor;
	my $content;
	
	# mvr[\
	if ($Form->IsExist('MOBILE_CONTENT')) {
		$Banner->Set('COLMB', $Form->Get('MOBILE_BGCOLOR'));
		$Banner->Set('TEXTMB', $Form->Get('MOBILE_CONTENT'));
		$bgColor = $Form->Get('MOBILE_BGCOLOR');
		$content = $Form->Get('MOBILE_CONTENT');
	}
	else {
		$bgColor = $Banner->Get('COLMB');
		$content = $Banner->Get('TEXTMB');
	}
	
	# vr[f[^̍쐬
	my $bdata = $Banner->Prepare(100, 0, 1);
	
	my $indata = {
		'title'		=> 'Mobile Banner Edit',
		'intmpl'	=> 'sys.edit.bannermb',
		'banner'	=> $bdata,
		'bgcolor'	=> $bgColor,
		'content'	=> $content,
	};
	
	return $indata;
}

#------------------------------------------------------------------------------------------------------------
#
#	m(Tu)ҏWʂ̕\
#	-------------------------------------------------------------------------------------
#	@param	$Sys	VXeϐ
#	@param	$Form	tH[ϐ
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub PreparePageBannerForSubEdit
{
	my ($Sys, $Form) = @_;
	
	require './module/denethor.pl';
	my $Banner = DENETHOR->new;
	$Banner->Load($Sys);
	
	my $content;
	
	# mvr[\
	if ($Form->IsExist('SUB_CONTENT')) {
		$Banner->Set('TEXTSB', $Form->Get('SUB_CONTENT'));
		$content = $Form->Get('SUB_CONTENT');
	}
	else {
		$content = $Banner->Get('TEXTSB');
	}
	
	# vr[f[^̍쐬
	my $bdata = $Banner->PrepareSub();
	
	my $indata = {
		'title'		=> 'Sub Banner Edit',
		'intmpl'	=> 'sys.edit.bannersub',
		'banner'	=> $bdata,
		'content'	=> $content,
	};
	
	return $indata;
}

#------------------------------------------------------------------------------------------------------------
#
#	mҏW
#	-------------------------------------------------------------------------------------
#	@param	$Sys	VXeϐ
#	@param	$Form	tH[ϐ
#	@param	$mode	
#	@param	$pLog	Op
#	@return	G[R[h
#
#------------------------------------------------------------------------------------------------------------
sub FunctionBannerEdit
{
	my ($Sys, $Form, $mode, $pLog) = @_;
	
	# `FbN
	my $Sec = $Sys->Get('ADMIN')->{'SECINFO'};
	my $cuser = $Sys->Get('ADMIN')->{'USER'};
	return 1000 if (!$Sec->IsAuthority($cuser, $ZP::AUTH_SYSADMIN, '*'));
	
	# ̓`FbN
	if ($mode == 1) {
		return 1001 if (!$Form->IsInput([qw(PC_CONTENT PC_BGCOLOR)]));
	} elsif ($mode == 2) {
		return 1001 if (!$Form->IsInput([qw(MOBILE_CONTENT MOBILE_BGCOLOR)]));
	}
	
	require './module/denethor.pl';
	my $Banner = DENETHOR->new;
	$Banner->Load($Sys);
	
	if ($mode == 1) {
		$Banner->Set('TEXTPC', $Form->Get('PC_CONTENT'));
		$Banner->Set('COLPC', $Form->Get('PC_BGCOLOR'));
		push @$pLog, 'PCpmݒ肵܂B';
	}
	elsif ($mode == 2) {
		$Banner->Set('TEXTMB', $Form->Get('MOBILE_CONTENT'));
		$Banner->Set('COLMB', $Form->Get('MOBILE_BGCOLOR'));
		push @$pLog, 'gїpmݒ肵܂B';
	}
	elsif ($mode == 3) {
		$Banner->Set('TEXTSB', $Form->Get('SUB_CONTENT'));
		push @$pLog, 'Tuoi[ݒ肵܂B';
	}
	
	# ݒ̕ۑ
	$Banner->Save($Sys);
	
	return 0;
}

#============================================================================================================
#	Module END
#============================================================================================================
1;
