package jp.coocan.la.aide.android.snapcard;

import java.util.List;

import android.app.Activity;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.net.Uri;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.util.DisplayMetrics;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.FrameLayout;


public class MainActivity extends Activity implements SensorEventListener {

	private MainView   mainView;
	private SnapinView snapinView;
	private SensorManager sensorManager = null;
	private boolean isRegiseredSensor = false;

	private float oldAccelerometerValue = 0.0f;


	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		initializeAppContainer();

		FrameLayout layout = new FrameLayout( this );
		layout.setBackgroundColor( Color.BLACK );
		setContentView(layout);

		//画面表示準備
		snapinView = new SnapinView(this);
		mainView = new MainView(this, snapinView);
		layout.addView(mainView);
		layout.addView(snapinView);

		//センサー準備
		sensorManager = (SensorManager)getSystemService(SENSOR_SERVICE);
	}


	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		super.onCreateOptionsMenu( menu );

		this.getMenuInflater().inflate( R.menu.main, menu );

		return true;
	}


	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		super.onOptionsItemSelected(item);

		switch(item.getItemId()){

		case R.id.menu_gallery : {
			startSelectCardImage();
			return true;
		}

		}

		return false;
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent intent) {
		super.onActivityResult( requestCode, resultCode, intent );

		if (resultCode != RESULT_OK) return;

		switch( requestCode ){

		case AppConst.IntentRequest.GALLERY :{
			completeSelectCardImage( intent );
		}

		}
	}

	@Override
	protected void onResume() {
		super.onResume();

		//加速度センサーのリスナー登録
		List<Sensor> sensors = sensorManager.getSensorList(Sensor.TYPE_ACCELEROMETER);
		if (sensors.size() > 0) {
			Sensor sensor = sensors.get(0);
			isRegiseredSensor = sensorManager.registerListener(
					this,
					sensor,
					SensorManager.SENSOR_DELAY_UI
					);
		}
	}

	@Override
	protected void onPause() {
		//加速度センサーのリスナー登録解除
		if (isRegiseredSensor) {
			sensorManager.unregisterListener( this );
			isRegiseredSensor = false;
		}

		super.onPause();
	}


	/** 
	 * センサー状態更新イベント
	 */
	public void onSensorChanged(SensorEvent event) {

		switch( event.sensor.getType() ){

		//加速度センサー
		case Sensor.TYPE_ACCELEROMETER : {
			//下方向への一定量以上の加速を抽出
			if( event.values[1] - oldAccelerometerValue >= AppConst.Device.ACCELEROMETER_SENSITIVITY ){
				mainView.startSnapIn();
			}
			oldAccelerometerValue = event.values[1];
		}

		}
	}

	public void onAccuracyChanged(Sensor sensor, int accuracy) {}


	/** 
	 * アプリケーション・コンテナの初期化
	 */
	public void initializeAppContainer(){

		//DisplayMetricsを初期化
		DisplayMetrics displayMetrics = new DisplayMetrics();
		this.getWindowManager().getDefaultDisplay().getMetrics( displayMetrics );
		AppContainer.setDisplayMetrics( displayMetrics );

		//ContentResolverを初期化
		AppContainer.setContentResolver( getContentResolver() );
	}

	/**
	 * 名刺画像の選択開始
	 */
	public void startSelectCardImage(){
		Intent intent = new Intent();
		intent.setType( "image/*" );
		intent.setAction( Intent.ACTION_PICK );
		intent.addCategory(Intent.CATEGORY_DEFAULT);
		startActivityForResult( intent, AppConst.IntentRequest.GALLERY );
	}

	/**
	 * 名刺画像の選択終了
	 * @param intent 選択に使用したIntent
	 */
	public void completeSelectCardImage(Intent intent){
		Uri uri= intent.getData();

		if( uri != null ){
			//画像のURI情報を保存
			SharedPreferences pref = PreferenceManager.getDefaultSharedPreferences(this);
			SharedPreferences.Editor editor = pref.edit();
			editor.putString( AppConst.Pref.CARDIMAGE_URI, uri.toString() );
			editor.commit();

			//画像をViewにロード
			mainView.loadCardBitmap( uri );
		}
	}


}