#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>

#include "PlaySequenceThread.h"

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

    QList<int> *FList;

private slots:
    void on_actionQuit_triggered();
    void on_actionAbout_triggered();
    void on_actionAboutQt_triggered();
    void on_Btn_Start_clicked();
    void on_Btn_Stop_clicked();
    void on_Btn_FudaSelect_clicked();
    void on_spinBox_1_valueChanged(int arg1);
    void on_spinBox_2_valueChanged(int arg1);
    void on_checkBox_toggled(bool checked);
    void on_actionFuda_triggered();

    //    signals:
    //        void SequencStartded();
    //        void Music1Starteded(int fudaNum);
    //        void Music1Ended();
    //        void Music2Starteded(int fudaNum);
    //        void Music2Ended();
    //        void SequenceEnded(int status); // status 0 is success, !0 is Fail
    void SequencStartded();
    void Music1Starteded(int fudaNum);
    void Music1Ended();
    void Music2Starteded(int fudaNum);
    void Music2Ended();
    void SequenceEnded(int status); // status 0 is success, !0 is Fail

    void on_actionOption_triggered();

    void on_Slider_Volume_valueChanged(int value);

    void on_Btn_AnkiJikan_clicked();

private:
    Ui::MainWindow *ui;

    void LoadSaveSetting(QString filepath, bool store);
    QString IniFilePath;

    bool flag_playseqstate; // SequenceExec flag, Executing is true;
    bool flag_pause;        // Pause flag, Pause is true

    QList<int> *PlayFudaList;
    PlaySequenceThread *PlaySeqTh;

    // Play setting property
    bool chk_joka; // joka yomiage
    int Wait1Time; // Interval kami-shimo
    int Wait2Time; // Interval next
    int SelectVoice; // select MusicFiles 0 = "Music" or 1 = "Music2"
    bool EnableOptMusic; // OptDialog, Enable Select Music2

    int PlayCounter;
    int PlayListCount;
    int prev_fudaNum;
};

#endif // MAINWINDOW_H
