#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>

#include <QGraphicsScene>
#include <QGraphicsView>
#include <QGraphicsItem>

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();


private slots:
    void on_Btn_Start_clicked();

    void on_Btn_Restart_clicked();

    void on_Btn_Stop_clicked();

    void on_Slct_Mode_currentIndexChanged(int index);

    void on_Slct_FudaMuki_currentIndexChanged(int index);

    void UpdateFuda();

    void EndingFuda();

    void TimeoutDone();

    void Fuda_clicked();

    void on_actionExit_triggered();

    void on_actionAbout_triggered();

    void on_actionAbout_Qt_triggered();

    void on_checkBox_DispKaminoku_stateChanged(int );

private:
    Ui::MainWindow *ui;

    QString AppPath;

    QPixmap pixmap;
    QGraphicsScene scene;
    QGraphicsPixmapItem* pixmapItem;

    QTimer *timer;

    bool execflag; // 実行中(true
    int mode; // モード自動(0)/手動(1)
    int maisu; // 枚数
    int waittime; // 待ち時間
    int muki;   // 札の向き 0=普通, 1=逆, 2=ランダム
    int fuda[100]; // fudaデータ 100枚分
    int fudaindex; // fudaデータ index
    bool retryOK; // もう一度有効
};

#endif // MAINWINDOW_H
