
#ifndef __USBRH_H__
#define __USBRH_H__

#if __LIBUSB_WIN32__
#include "lusb0_usb.h"
#else
#include <usb.h>
#endif

#define USBRH_VENDOR  0x1774
#define USBRH_PRODUCT 0x1001

// parameter
// http://www.sensirion.com/en/pdf/product_information/Data_Sheet_humidity_sensor_SHT1x_SHT7x_E.pdf
// http://www.syscom-inc.co.jp/pdf/sht_datasheet_j.pdf
#define d1 -40.00
#define d2 0.01
#define c1 -4
#define c2 0.0405
#define c3 -0.0000028
#define t1 0.01
#define t2 0.00008

class usbrh
{

private:
    double convert_temp(int in);
    double convert_humidity(int in);
    struct usb_device *searchdevice(unsigned int vendor, unsigned int product, int num);
    struct usb_device *listdevice(unsigned int vendor, unsigned int product);

    struct usb_device *gDevice;
    usb_dev_handle *gDevHandle;

public:
    usbrh();
    ~usbrh();

    int open();
    int config();
    int get_tempr_humid(double *tempr, double *humid);
    void close();

};

#endif /* __USBRH_H__ */
