﻿Imports PdfiumViewer
Public Class frmPdfViewer

    Dim pdfDoc As PdfDocument
    Dim page As Integer = 0
    Public Sub OpenFile(fileName As String)

        pdfDoc = PdfDocument.Load(fileName)
        FirstPage()
    End Sub

    Public Sub FirstPage()
        page = 0
        DisplayPage()
    End Sub

    Public Sub NextPage()
        If page < pdfDoc.PageCount Then
            page += 1
            DisplayPage()
        End If
    End Sub

    Public Sub PrePage()
        If 0 < page Then
            page -= 1
            DisplayPage()
        End If
    End Sub

    Private Sub DisplayPage()
        If (page >= pdfDoc.PageCount) Then
            Return
        End If
        Dim renderSize As Size? = GetRenderSize()
        If renderSize Is Nothing Then
            Return
        End If
        Render(renderSize)
    End Sub

    Private Function GetRenderSize() As Size?
        Dim renderSize = New Size(PictureBox1.Size)
        Dim pdfSize = pdfDoc.PageSizes(page)
        Dim pdfWdivH = pdfSize.Width / pdfSize.Height ' // pdfの縦横比
        Dim boxWdivH = PictureBox1.Width / PictureBox1.Height '  // コントロールの縦横比
        If (boxWdivH > 10) Then ' 落ちないよう
            Return Nothing
        End If
        If (pdfWdivH < boxWdivH) Then
            ' フォーム内にImageを当てはめる判定                    {
            renderSize.Width = PictureBox1.Height * pdfWdivH
        Else
            renderSize.Height = PictureBox1.Width / pdfWdivH
        End If
        Return renderSize
    End Function

    Private Sub Render(renderSize As Size)
        Dim img = pdfDoc.Render(page, renderSize.Width, renderSize.Height, 96, 96, False) '  // 解像度は意味ない？
        Dim oldImage = PictureBox1.Image
        PictureBox1.Image = img
        If oldImage IsNot Nothing Then
            oldImage.Dispose() ';  // メモリー節約
        End If

    End Sub

End Class