﻿///////////////////////////////////////////////////////////////////////////////
// This file is part of ConfigurationManager.
///////////////////////////////////////////////////////////////////////////////
// Copyright (C) 2009-2011 bis5 <bis5@users.sourceforge.jp>
// All rights reserved.
///////////////////////////////////////////////////////////////////////////////
// ConfigurationManager is one of modules for SharpWebBrowser.
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the Microsoft Public Licence (Ms-PL) as published by 
// Microsoft Corp.
//
// You should have received a copy of the Microsoft Public License along 
// with this program. 
// If not, see <http://www.microsoft.com/opensource/licenses.mspx>
//
///////////////////////////////////////////////////////////////////////////////
//
// File information
// Name: Configure.cs, Configure.Designer.cs
// Author: bis5
// Module: ConfigurationManager
//
///////////////////////////////////////////////////////////////////////////////

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Bis5Products.SharpWebBrowser {
    public partial class Configure : Form {

        public Configure() {
            InitializeComponent();
            this.AcceptButton = (IButtonControl)OKbutton;
        }

        private void OKbutton_Click(object sender, EventArgs e) {
            Applybutton_Click(sender, e);
            this.DialogResult = DialogResult.OK;
            this.Close();
        }

        private void Cancelbutton_Click(object sender, EventArgs e) {
            this.DialogResult = DialogResult.Cancel;
            this.Close();
        }

        private void Applybutton_Click(object sender, EventArgs e) {
            foreach (var cl in ConfigurationManager.propsheet) {
                cl.Commit();
            }
        }

        private void listBox1_SelectedIndexChanged(object sender, EventArgs e) {
            if (listBox1.SelectedItem != null) {
                groupBox1.Controls.Clear();
                groupBox1.Text = listBox1.SelectedItem.ToString();
                groupBox1.Controls.Add((Control)ConfigurationManager.propsheet[listBox1.SelectedIndex]);
            }
        }

        private void Configure_Load(object sender, EventArgs e) {
            listBox1.SelectedIndex = 0;
            foreach (var cl in ConfigurationManager.propsheet) {
                cl.Load();
            }
        }
        ILangMgr lang;
        internal void SetLanguageManager(ILangMgr language) {
            lang = language;
            lang.AppendDelegate(new LmgrAppender(loadLanguage));
            loadLanguage();
        }
        private void loadLanguage() {
            OKbutton.Text = lang.Get("Generic_OK");
            Cancelbutton.Text = lang.Get("Generic_Cancel");
            Applybutton.Text = lang.Get("Generic_Apply");
            this.Text = lang.Get("ConfigurationManager_FormName");
        }

    }
}