﻿///////////////////////////////////////////////////////////////////////////////
// This file is part of SharpWebBrowser.
///////////////////////////////////////////////////////////////////////////////
// Copyright (C) 2009-2011 bis5 <bis5@users.sourceforge.jp>
// All rights reserved.
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the Microsoft Public Licence (Ms-PL) as published by 
// Microsoft Corp.
//
// You should have received a copy of the Microsoft Public License along 
// with this program. 
// If not, see <http://www.microsoft.com/opensource/licenses.mspx>
//
///////////////////////////////////////////////////////////////////////////////
//
// File information
// Name: ILangMgr.cs
// Author: bis5
//
///////////////////////////////////////////////////////////////////////////////


using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Bis5Products.SharpWebBrowser {
    /// <summary>SharpWebBrowserで利用するLanguageManagerモジュールに必要な機能を実装します。</summary>
    public interface ILangMgr : ISWBModules {
        /// <summary>言語定数を取得します。</summary>
        /// <param name="code">取得する言語定数名</param>
        /// <returns>言語定数文字列</returns>
        string Get(string code);
        /// <summary>言語定数を取得します。このメソッドは互換性維持のために残されています。</summary>
        /// <param name="code">取得する言語定数名</param>
        /// <returns>言語定数文字列</returns>
        string GetValue(string code);
        /// <summary>設定で使用言語を変更した際に、適用するために呼び出されるメソッドを登録します。</summary>
        /// <param name="ev">呼び出されるメソッドを登録した<see cref="LmgrAppender"/>デリゲート。</param>
        void AppendDelegate(LmgrAppender ev);
        /// <summary>設定で使用言語を変更した際に、適用するために呼び出されるメソッドを登録します。</summary>
        /// <param name="ev">呼び出されるメソッドを登録した<see cref="LmgrAppender"/>デリゲート。</param>
        /// <param name="callback">メソッドを登録したあとに呼び出す場合はtrueを指定して下さい。</param>
        void AppendDelegate(LmgrAppender ev, bool callback);
    }
}
