﻿///////////////////////////////////////////////////////////////////////////////
// This file is part of SharpWebBrowser.
///////////////////////////////////////////////////////////////////////////////
// Copyright (C) 2009-2011 bis5 <bis5@users.sourceforge.jp>
// All rights reserved.
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the Microsoft Public Licence (Ms-PL) as published by 
// Microsoft Corp.
//
// You should have received a copy of the Microsoft Public License along 
// with this program. 
// If not, see <http://www.microsoft.com/opensource/licenses.mspx>
//
///////////////////////////////////////////////////////////////////////////////
//
// File information
// Name: LanguageSetItem.cs
// Author: bis5
//
///////////////////////////////////////////////////////////////////////////////

using System;
using System.Collections.Generic;
using System.Xml.Serialization;

namespace Bis5Products.SharpWebBrowser {
    [Serializable()]
    public class LanguageSetItem {
        [XmlAttribute("key")]
        private string _key;
        [XmlText()]
        private string _value;

        /// <summary>
        /// <remarks>LanguageSetItem</remarks>の新しいインスタンスを開始します。
        /// </summary>
        public LanguageSetItem() { }

        /// <summary>
        /// <see cref="LanguageSetItem"/s>の新しいインスタンスを開始します。
        /// </summary>
        /// <param name="key"><see cref="LanguageSetItem"/>の名称</param>
        /// <param name="value"><see cref="LanguageSetItem"/>の値</param>
        public LanguageSetItem(string key, string value) { _key = key; _value = value; }

        public string Key {
            get { return _key; }
        }

        public string Value {
            get { return _value; }
        }

    }// class LanguageSetItem
}// namespace Bis5Products.SharpWebBrowser
