﻿///////////////////////////////////////////////////////////////////////////////
// This file is part of SharpWebBrowser.
///////////////////////////////////////////////////////////////////////////////
// Copyright (C) 2009-2011 bis5 <bis5@users.sourceforge.jp>
// All rights reserved.
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the Microsoft Public Licence (Ms-PL) as published by 
// Microsoft Corp.
//
// You should have received a copy of the Microsoft Public License along 
// with this program. 
// If not, see <http://www.microsoft.com/opensource/licenses.mspx>
//
///////////////////////////////////////////////////////////////////////////////
//
// File information
// Name: SearchProviderInfo.cs
// Author: bis5
//
///////////////////////////////////////////////////////////////////////////////

using System;
using System.Xml.Serialization;

namespace Bis5Products.SharpWebBrowser {
    [Serializable()]
    [XmlRoot("SearchProviderInfo")]
    public class SearchProviderInfo {
        [XmlAttribute("Query")]
        private string _query;
        [XmlAttribute("Name")]
        private string _name;

        public SearchProviderInfo() { }

        public SearchProviderInfo(string query, string name) {
            Query = query; Name = name;
        }

        public string Query {
            get { return _query; }
            set { _query = value; }
        }

        public string Name {
            get { return _name; }
            set { _name = value; }
        }
    }
}